/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;

interface IMoleculeCountStrategy {
    public int getNumberOfMolecules(double var1, int var3);

    public static class ConcentrationMoleculeCountStrategy
    implements IMoleculeCountStrategy {
        public int getNumberOfMolecules(double d, int n) {
            double d2 = MathUtil.log10(d / 1.0E-7);
            double d3 = Math.pow(n / 2, 1.0 / MathUtil.log10(1.0E7));
            return (int)(2.0 * Math.pow(d3, d2));
        }
    }

    public static class ConstantMoleculeCountStrategy
    implements IMoleculeCountStrategy {
        public int getNumberOfMolecules(double d, int n) {
            return n;
        }
    }
}

