/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.model.Beaker;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

public class BeakerNode
extends PComposite {
    private static final Stroke STROKE = new BasicStroke(6.0f, 1, 1);
    private static final Color STROKE_COLOR = Color.BLACK;
    private static final String[] MAJOR_TICK_LABELS = new String[]{null, "1"};
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Stroke MINOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Font TICK_LABEL_FONT = new PhetFont(24);
    private final Beaker beaker;
    private final PPath outlineNode;
    private final PPath solutionNode;
    private final GeneralPath outlinePath;
    private final Rectangle2D solutionRectangle;
    private final PComposite ticksNode;

    public BeakerNode(final Beaker beaker) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.beaker = beaker;
        beaker.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void solutionChanged() {
                BeakerNode.this.solutionNode.setPaint(beaker.getSolution().getColor());
            }
        });
        this.solutionRectangle = new Rectangle2D.Double();
        this.solutionNode = new PPath();
        this.solutionNode.setPaint(beaker.getSolution().getColor());
        this.solutionNode.setStroke(null);
        this.addChild(this.solutionNode);
        this.outlinePath = new GeneralPath();
        this.outlineNode = new PPath();
        this.outlineNode.setPaint(null);
        this.outlineNode.setStroke(STROKE);
        this.outlineNode.setStrokePaint(STROKE_COLOR);
        this.addChild(this.outlineNode);
        this.ticksNode = new PComposite();
        this.addChild(this.ticksNode);
        this.setOffset(beaker.getLocationReference());
        this.setVisible(beaker.isVisible());
        this.update();
    }

    private void update() {
        this.updateBeaker();
        this.updateTicks();
        this.updateSolution();
    }

    private double getOriginXOffset() {
        return this.beaker.getWidth() / 2.0;
    }

    private double getOriginYOffset() {
        return this.beaker.getHeight();
    }

    private void updateBeaker() {
        this.outlinePath.reset();
        double d = this.getOriginXOffset();
        double d2 = this.getOriginYOffset();
        this.outlinePath.moveTo((float)(-d - 20.0), (float)(-d2 - 20.0));
        this.outlinePath.lineTo((float)(-d), (float)(-d2));
        this.outlinePath.lineTo((float)(-d), (float)(this.beaker.getHeight() - d2));
        this.outlinePath.lineTo((float)(this.beaker.getWidth() - d), (float)(this.beaker.getHeight() - d2));
        this.outlinePath.lineTo((float)(this.beaker.getWidth() - d), (float)(-d2));
        this.outlinePath.lineTo((float)(this.beaker.getWidth() - d + 20.0), (float)(-d2 - 20.0));
        this.outlineNode.setPathTo(this.outlinePath);
    }

    private void updateSolution() {
        double d = this.getOriginXOffset();
        double d2 = this.getOriginYOffset();
        this.solutionRectangle.setRect(-d, -d2, this.beaker.getWidth(), this.beaker.getHeight());
        this.solutionNode.setPathTo(this.solutionRectangle);
    }

    private void updateTicks() {
        this.ticksNode.removeAllChildren();
        int n = (int)Math.round(10.0);
        double d = this.getOriginXOffset();
        double d2 = this.beaker.getHeight() - this.getOriginYOffset();
        double d3 = this.beaker.getHeight() / (double)n;
        for (int i = 1; i <= n; ++i) {
            PPath pPath;
            Line2D.Double double_;
            double d4 = d2 - (double)i * d3;
            if (i % 5 == 0) {
                double_ = new Line2D.Double(d - 30.0, d4, d - 2.0, d4);
                pPath = new PPath(double_);
                pPath.setStroke(MAJOR_TICK_STROKE);
                pPath.setStrokePaint(TICK_COLOR);
                this.ticksNode.addChild(pPath);
                int n2 = i / 5 - 1;
                if (n2 >= MAJOR_TICK_LABELS.length || MAJOR_TICK_LABELS[n2] == null) continue;
                String string = MessageFormat.format(ABSStrings.PATTERN_VALUE_UNITS, MAJOR_TICK_LABELS[n2], ABSStrings.LITERS);
                PText pText = new PText(string);
                pText.setFont(TICK_LABEL_FONT);
                pText.setTextPaint(TICK_COLOR);
                this.ticksNode.addChild(pText);
                double d5 = pPath.getFullBounds().getMinX() - pText.getFullBoundsReference().getWidth() - 8.0;
                double d6 = pPath.getFullBounds().getMinY() - pText.getFullBoundsReference().getHeight() / 2.0;
                pText.setOffset(d5, d6);
                continue;
            }
            double_ = new Line2D.Double(d - 15.0, d4, d - 2.0, d4);
            pPath = new PPath(double_);
            pPath.setStroke(MINOR_TICK_STROKE);
            pPath.setStrokePaint(TICK_COLOR);
            this.ticksNode.addChild(pPath);
        }
    }
}

