/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.model.ConductivityTester;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserAction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.ConductivityTesterNode;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;

public class ABSConductivityTesterNode
extends ConductivityTesterNode {
    public ABSConductivityTesterNode(final ConductivityTester conductivityTester, boolean bl) {
        super(UserComponents.conductivityTester, conductivityTester, ModelViewTransform.createIdentity(), Color.BLACK, Color.RED, Color.BLACK, bl);
        conductivityTester.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                ABSConductivityTesterNode.this.setVisible(conductivityTester.isVisible());
            }
        });
        this.getLightBulbNode().addInputEventListener(new NonInteractiveEventHandler(ABSSimSharing.UserComponents.lightBulb));
        this.getBatteryNode().addInputEventListener(new NonInteractiveEventHandler(ABSSimSharing.UserComponents.battery));
        SimSharingDragHandler.DragFunction dragFunction = new SimSharingDragHandler.DragFunction(){

            public void apply(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet, PInputEvent pInputEvent) {
                ABSConductivityTesterNode.sendProbeEvent(iUserComponent, iUserAction, conductivityTester.isPositiveProbeInSolution(), conductivityTester.isCircuitCompleted());
            }
        };
        this.getPositiveProbeDragHandler().setStartDragFunction(dragFunction);
        this.getPositiveProbeDragHandler().setEndDragFunction(dragFunction);
        this.getPositiveProbeDragHandler().setDragFunction(new SimSharingDragHandler.DragFunction(){
            boolean inSolution;
            {
                this.inSolution = conductivityTester.isPositiveProbeInSolution();
            }

            public void apply(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet, PInputEvent pInputEvent) {
                if (this.inSolution != conductivityTester.isPositiveProbeInSolution()) {
                    ABSConductivityTesterNode.sendProbeEvent(iUserComponent, iUserAction, conductivityTester.isPositiveProbeInSolution(), conductivityTester.isCircuitCompleted());
                }
                this.inSolution = conductivityTester.isPositiveProbeInSolution();
            }
        });
        dragFunction = new SimSharingDragHandler.DragFunction(){

            public void apply(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet, PInputEvent pInputEvent) {
                ABSConductivityTesterNode.sendProbeEvent(iUserComponent, iUserAction, conductivityTester.isNegativeProbeInSolution(), conductivityTester.isCircuitCompleted());
            }
        };
        this.getNegativeProbeDragHandler().setStartDragFunction(dragFunction);
        this.getNegativeProbeDragHandler().setEndDragFunction(dragFunction);
        this.getNegativeProbeDragHandler().setDragFunction(new SimSharingDragHandler.DragFunction(){
            boolean inSolution;
            {
                this.inSolution = conductivityTester.isNegativeProbeInSolution();
            }

            public void apply(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet, PInputEvent pInputEvent) {
                if (this.inSolution != conductivityTester.isNegativeProbeInSolution()) {
                    ABSConductivityTesterNode.sendProbeEvent(iUserComponent, iUserAction, conductivityTester.isNegativeProbeInSolution(), conductivityTester.isCircuitCompleted());
                }
                this.inSolution = conductivityTester.isNegativeProbeInSolution();
            }
        });
    }

    private static void sendProbeEvent(IUserComponent iUserComponent, IUserAction iUserAction, boolean bl, boolean bl2) {
        SimSharingManager.sendUserMessage(iUserComponent, UserComponentTypes.sprite, iUserAction, ParameterSet.parameterSet((IParameterKey)ABSSimSharing.ParameterKeys.isInSolution, bl).with((IParameterKey)ABSSimSharing.ParameterKeys.isCircuitCompleted, bl2));
    }
}

