/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.test;

import edu.colorado.phet.acidbasesolutions.constants.ABSColors;
import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.constants.ABSImages;
import edu.colorado.phet.acidbasesolutions.model.Beaker;
import edu.colorado.phet.acidbasesolutions.model.PHPaper;
import edu.colorado.phet.acidbasesolutions.model.PureWaterSolution;
import edu.colorado.phet.acidbasesolutions.view.PHColorKeyNode;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ABSTestColorblindness
extends PhetApplication {
    public ABSTestColorblindness(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.addModule(new TestModule());
        this.getPhetFrame().setTitle("Acid-Base Solution colorblind test");
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(stringArray, "acid-base-solutions", ABSTestColorblindness.class);
    }

    private static class TestCanvas
    extends PhetPCanvas {
        public TestCanvas() {
            TestColorKeyNode testColorKeyNode = new TestColorKeyNode();
            this.addChild(testColorKeyNode);
            testColorKeyNode.setOffset(50.0, 10.0);
            double d = testColorKeyNode.getXOffset();
            double d2 = testColorKeyNode.getFullBoundsReference().getMaxY() + 10.0;
            double d3 = 50.0;
            this.addMoleculeImage(ABSImages.A_MINUS_MOLECULE, "<i>A</i><sup>-</sup>", d, d2);
            this.addMoleculeImage(ABSImages.B_MOLECULE, "<i>B</i>", d, d2 += d3);
            this.addMoleculeImage(ABSImages.BH_PLUS_MOLECULE, "<i>B</i>H<sup>+</sup>", d, d2 += d3);
            this.addMoleculeImage(ABSImages.H2O_MOLECULE, "H<sub>2</sub>O", d, d2 += d3);
            this.addMoleculeImage(ABSImages.H3O_PLUS_MOLECULE, "H<sub>3</sub>O<sup>+</sup>", d, d2 += d3);
            this.addMoleculeImage(ABSImages.HA_MOLECULE, "H<i>A</i>", d, d2 += d3);
            this.addMoleculeImage(ABSImages.M_PLUS_MOLECULE, "<i>M</i><sup>+</sup>", d, d2 += d3);
            this.addMoleculeImage(ABSImages.MOH_MOLECULE, "<i>M</i>OH", d, d2 += d3);
            this.addMoleculeImage(ABSImages.OH_MINUS_MOLECULE, "OH<sup>-</sup>", d, d2 += d3);
            d2 += d3;
            d = 150.0;
            d2 = testColorKeyNode.getFullBoundsReference().getMaxY() + 10.0;
            d3 = TestColorBarNode.BAR_SIZE.getHeight() + 25.0;
            this.addColorBar(ABSColors.A_MINUS, "<i>A</i><sup>-</sup>", d, d2);
            this.addColorBar(ABSColors.B, "<i>B</i>", d, d2 += d3);
            this.addColorBar(ABSColors.BH_PLUS, "<i>B</i>H<sup>+</sup>", d, d2 += d3);
            this.addColorBar(ABSColors.H2O, "H<sub>2</sub>O", d, d2 += d3);
            this.addColorBar(ABSColors.H3O_PLUS, "H<sub>3</sub>O<sup>+</sup>", d, d2 += d3);
            this.addColorBar(ABSColors.HA, "H<i>A</i>", d, d2 += d3);
            this.addColorBar(ABSColors.M_PLUS, "<i>M</i><sup>+</sup>", d, d2 += d3);
            this.addColorBar(ABSColors.MOH, "<i>M</i>OH", d, d2 += d3);
            this.addColorBar(ABSColors.OH_MINUS, "OH<sup>-</sup>", d, d2 += d3);
            this.addColorBar(ABSColors.CANVAS_BACKGROUND, "canvas background", d, d2 += d3);
            this.addColorBar(ABSColors.CONTROL_PANEL_BACKGROUND, "control panel background", d, d2 += d3);
            d2 += d3;
        }

        private void addChild(PNode pNode) {
            this.getLayer().addChild(pNode);
        }

        private void addMoleculeImage(Image image, String string, double d, double d2) {
            TestMoleculeImageNode testMoleculeImageNode = new TestMoleculeImageNode(image, string);
            this.addChild(testMoleculeImageNode);
            testMoleculeImageNode.setOffset(d, d2);
        }

        private void addColorBar(Color color, String string, double d, double d2) {
            TestColorBarNode testColorBarNode = new TestColorBarNode(color, string);
            this.addChild(testColorBarNode);
            testColorBarNode.setOffset(d, d2);
        }
    }

    private static class TestColorBarNode
    extends PComposite {
        private static final Dimension BAR_SIZE = new Dimension(100, 25);

        public TestColorBarNode(Color color, String string) {
            PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, TestColorBarNode.BAR_SIZE.width, TestColorBarNode.BAR_SIZE.height));
            pPath.setPaint(color);
            pPath.setStroke(new BasicStroke(1.0f));
            pPath.setStrokePaint(Color.BLACK);
            this.addChild(pPath);
            HTMLNode hTMLNode = new HTMLNode(string);
            hTMLNode.setFont(new PhetFont(12));
            this.addChild(hTMLNode);
            pPath.setOffset(0.0, 0.0);
            hTMLNode.setOffset(pPath.getFullBoundsReference().getMaxX() + 3.0, pPath.getFullBoundsReference().getMinY());
        }
    }

    private static class TestColorKeyNode
    extends PComposite {
        public TestColorKeyNode() {
            PureWaterSolution pureWaterSolution = new PureWaterSolution();
            Beaker beaker = new Beaker(pureWaterSolution, new Point2D.Double(), true, ABSConstants.BEAKER_SIZE);
            PHPaper pHPaper = new PHPaper(pureWaterSolution, new Point2D.Double(), true, ABSConstants.PH_PAPER_SIZE, beaker);
            PHColorKeyNode pHColorKeyNode = new PHColorKeyNode(pHPaper);
            pHColorKeyNode.scale(0.75);
            this.addChild(pHColorKeyNode);
        }
    }

    private static class TestModule
    extends PiccoloModule {
        public TestModule() {
            super("TestModule", new ConstantDtClock(40, 1.0), true);
            this.setClockControlPanel(null);
            this.setControlPanel(null);
            this.setLogoPanelVisible(false);
            this.setSimulationPanel(new TestCanvas());
        }
    }

    private static class TestMoleculeImageNode
    extends PComposite {
        public TestMoleculeImageNode(Image image, String string) {
            PImage pImage = new PImage(image);
            this.addChild(pImage);
            HTMLNode hTMLNode = new HTMLNode(string);
            hTMLNode.setFont(new PhetFont(12));
            this.addChild(hTMLNode);
            pImage.setOffset(0.0, 0.0);
            hTMLNode.setOffset(pImage.getFullBoundsReference().getMaxX() + 3.0, pImage.getFullBoundsReference().getMinY());
        }
    }
}

