/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcid;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LogarithmicValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.SimSharingLogarithmicValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class WeakAcidControls
extends JPanel {
    private final WeakAcid weakAcid;
    private final LogarithmicValueControl concentrationControl;
    private final LogarithmicValueControl strengthControl;

    public WeakAcidControls(JFrame jFrame, final WeakAcid weakAcid) {
        this.setBorder(new TitledBorder("Solution (weak acid)"));
        this.weakAcid = weakAcid;
        weakAcid.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WeakAcidControls.this.updateControls();
            }
        });
        DoubleRange doubleRange = MGPConstants.WEAK_ACID_CONCENTRATION_RANGE;
        this.concentrationControl = new SimSharingLogarithmicValueControl(ABSSimSharing.UserComponents.concentrationControl, doubleRange.getMin(), doubleRange.getMax(), "concentration:", "0.0E0", "mol/L");
        this.concentrationControl.setBorder(new EtchedBorder());
        this.concentrationControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                weakAcid.setConcentration(WeakAcidControls.this.concentrationControl.getValue());
            }
        });
        DoubleRange doubleRange2 = MGPConstants.WEAK_ACID_STRENGTH_RANGE;
        this.strengthControl = new SimSharingLogarithmicValueControl(ABSSimSharing.UserComponents.weakStrengthControl, doubleRange2.getMin(), doubleRange2.getMax(), "strength:", "0.0E0", "");
        this.strengthControl.setBorder(new EtchedBorder());
        this.strengthControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                weakAcid.setStrength(WeakAcidControls.this.strengthControl.getValue());
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this.concentrationControl, n++, n2);
        easyGridBagLayout.addComponent(this.strengthControl, n++, n2);
        this.updateControls();
    }

    private void updateControls() {
        this.concentrationControl.setValue(this.weakAcid.getConcentration());
        this.strengthControl.setValue(this.weakAcid.getStrength());
    }
}

