/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.Changeable;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import java.awt.Color;

class WeakAcid
extends Changeable {
    private double concentration;
    private double strength;
    private Color color;

    public WeakAcid() {
        this(MGPConstants.WEAK_ACID_CONCENTRATION_RANGE.getDefault(), MGPConstants.WEAK_ACID_STRENGTH_RANGE.getDefault(), MGPConstants.COLOR_WEAK_ACID);
    }

    public WeakAcid(double d, double d2, Color color) {
        this.concentration = d;
        this.strength = d2;
        this.color = color;
    }

    public void setConcentration(double d) {
        if (d != this.concentration) {
            this.concentration = d;
            this.fireStateChanged();
        }
    }

    public double getConcentration() {
        return this.concentration;
    }

    public void setStrength(double d) {
        if (d != this.strength) {
            this.strength = d;
            this.fireStateChanged();
        }
    }

    public double getStrength() {
        return this.strength;
    }

    public void setColor(Color color) {
        if (!color.equals(this.color)) {
            this.color = color;
            this.fireStateChanged();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public double getPH() {
        return -MathUtil.log10(this.getConcentrationH3O());
    }

    public double getConcentrationHA() {
        return this.getConcentration() - this.getConcentrationA();
    }

    public double getConcentrationA() {
        double d = this.getStrength();
        double d2 = this.getConcentration();
        return (-d + Math.sqrt(d * d + 4.0 * d * d2)) / 2.0;
    }

    public double getConcentrationH3O() {
        return this.getConcentrationA();
    }

    public double getConcentrationOH() {
        return 1.0E-14 / this.getConcentrationH3O();
    }

    public double getConcentrationH2O() {
        return 55.6 - this.getConcentrationA();
    }

    public double getMoleculeCountHA() {
        return WeakAcid.getMoleculeCount(this.getConcentrationHA());
    }

    public double getMoleculeCountA() {
        return WeakAcid.getMoleculeCount(this.getConcentrationA());
    }

    public double getMoleculeCountH3O() {
        return WeakAcid.getMoleculeCount(this.getConcentrationH3O());
    }

    public double getMoleculeCountOH() {
        return WeakAcid.getMoleculeCount(this.getConcentrationOH());
    }

    public double getMoleculeCountH2O() {
        return WeakAcid.getMoleculeCount(this.getConcentrationH2O());
    }

    protected static double getMoleculeCount(double d) {
        return d * 6.022E23;
    }
}

