/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.IMoleculeCountStrategy;
import edu.colorado.phet.acidbasesolutions.prototype.IMoleculeLayeringStrategy;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcid;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

abstract class MoleculesNode
extends PComposite {
    private final WeakAcid solution;
    private final MagnifyingGlass magnifyingGlass;
    private final MoleculeParentNode parentHA;
    private final MoleculeParentNode parentA;
    private final MoleculeParentNode parentH3O;
    private final MoleculeParentNode parentOH;
    private final MoleculeParentNode parentH2O;
    private final EventListenerList listeners;
    private final IMoleculeCountStrategy moleculeCountStrategy;
    private final IMoleculeCountStrategy h2oCountStrategy;
    private final IMoleculeLayeringStrategy layeringStrategy;
    private int maxMolecules;
    private int maxH2O;
    private float moleculeTransparency;
    private float h2oTransparency;
    private int countHA;
    private int countA;
    private int countH3O;
    private int countOH;
    private int countH2O;

    public MoleculesNode(WeakAcid weakAcid, MagnifyingGlass magnifyingGlass, int n, int n2, float f, IMoleculeCountStrategy iMoleculeCountStrategy, IMoleculeCountStrategy iMoleculeCountStrategy2, boolean bl) {
        this.setPickable(false);
        this.maxMolecules = n;
        this.maxH2O = n2;
        this.moleculeTransparency = this.h2oTransparency = f;
        this.moleculeCountStrategy = iMoleculeCountStrategy;
        this.h2oCountStrategy = iMoleculeCountStrategy2;
        this.listeners = new EventListenerList();
        this.layeringStrategy = new IMoleculeLayeringStrategy.WeakAcidLayeringStrategy();
        this.magnifyingGlass = magnifyingGlass;
        magnifyingGlass.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MoleculesNode.this.deleteAllMolecules();
                MoleculesNode.this.updateNumberOfMolecules();
            }
        });
        this.solution = weakAcid;
        weakAcid.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MoleculesNode.this.updateNumberOfMolecules();
                MoleculesNode.this.fireStateChanged();
            }
        });
        this.parentHA = new MoleculeParentNode();
        this.parentA = new MoleculeParentNode();
        this.parentH3O = new MoleculeParentNode();
        this.parentOH = new MoleculeParentNode();
        this.parentH2O = new MoleculeParentNode();
        this.addChild(this.parentH2O);
        this.addChild(this.parentHA);
        this.addChild(this.parentA);
        this.addChild(this.parentH3O);
        this.addChild(this.parentOH);
        this.parentOH.setVisible(bl);
        this.parentH2O.setVisible(false);
    }

    public boolean isH2OVisible() {
        return this.parentH2O.getVisible();
    }

    public void setH2OVisible(boolean bl) {
        if (bl != this.isH2OVisible()) {
            this.parentH2O.setVisible(bl);
            this.fireStateChanged();
        }
    }

    public int getMaxMolecules() {
        return this.maxMolecules;
    }

    public void setMaxMolecules(int n) {
        if (n != this.maxMolecules) {
            this.maxMolecules = n;
            this.updateNumberOfMolecules();
            this.fireStateChanged();
        }
    }

    public int getMaxH2O() {
        return this.maxH2O;
    }

    public void setMaxH2O(int n) {
        if (n != this.maxH2O) {
            this.maxH2O = n;
            this.updateNumberOfMolecules();
            this.fireStateChanged();
        }
    }

    public float getMoleculeTransparency() {
        return this.moleculeTransparency;
    }

    public void setMoleculeTransparency(float f) {
        if (f != this.moleculeTransparency) {
            this.moleculeTransparency = f;
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                PNode pNode = this.getChild(i);
                if (!(pNode instanceof MoleculeParentNode) || pNode == this.getParentH2O()) continue;
                this.updateTransparency(pNode, f);
            }
            this.fireStateChanged();
        }
    }

    public float getH2OTransparency() {
        return this.h2oTransparency;
    }

    public void setH2OTransparency(float f) {
        if (f != this.h2oTransparency) {
            this.h2oTransparency = f;
            this.updateTransparency(this.getParentH2O(), f);
            this.fireStateChanged();
        }
    }

    protected abstract void updateTransparency(PNode var1, float var2);

    public int getCountHA() {
        return this.countHA;
    }

    public int getCountA() {
        return this.countA;
    }

    public int getCountH3O() {
        return this.countH3O;
    }

    public int getCountOH() {
        return this.countOH;
    }

    public int getCountH2O() {
        return this.countH2O;
    }

    protected PNode getParentHA() {
        return this.parentHA;
    }

    protected PNode getParentA() {
        return this.parentA;
    }

    protected PNode getParentH3O() {
        return this.parentH3O;
    }

    protected PNode getParentOH() {
        return this.parentOH;
    }

    protected PNode getParentH2O() {
        return this.parentH2O;
    }

    protected void updateNumberOfMolecules() {
        this.countHA = this.moleculeCountStrategy.getNumberOfMolecules(this.solution.getConcentrationHA(), this.maxMolecules);
        this.countA = this.moleculeCountStrategy.getNumberOfMolecules(this.solution.getConcentrationA(), this.maxMolecules);
        this.countH3O = this.moleculeCountStrategy.getNumberOfMolecules(this.solution.getConcentrationH3O(), this.maxMolecules);
        this.countOH = this.moleculeCountStrategy.getNumberOfMolecules(this.solution.getConcentrationOH(), this.maxMolecules);
        this.countH2O = this.h2oCountStrategy.getNumberOfMolecules(this.solution.getConcentrationH2O(), this.maxH2O);
        this.updateNumberOfMoleculeNodes();
        this.layeringStrategy.setRenderingOrder(this.parentHA, this.parentA, this.parentH3O, this.parentOH, this.parentH2O);
    }

    protected abstract void updateNumberOfMoleculeNodes();

    private void deleteAllMolecules() {
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            PNode pNode = this.getChild(i);
            if (!(pNode instanceof MoleculeParentNode)) continue;
            pNode.removeAllChildren();
        }
        this.countH2O = 0;
        this.countOH = 0;
        this.countH3O = 0;
        this.countA = 0;
        this.countHA = 0;
    }

    protected Point2D getRandomPoint() {
        double d = this.magnifyingGlass.getDiameter() / 2;
        double d2 = d * Math.sqrt(Math.random());
        double d3 = Math.random() * 2.0 * Math.PI;
        double d4 = d2 * Math.cos(d3);
        double d5 = d2 * Math.sin(d3);
        return new Point2D.Double(d4, d5);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    protected static class MoleculeParentNode
    extends PComposite {
        protected MoleculeParentNode() {
        }
    }
}

