/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.DotsNode;
import edu.colorado.phet.acidbasesolutions.prototype.ImagesNode;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlassNode;
import edu.colorado.phet.acidbasesolutions.prototype.NumberNode;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcid;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.swing.SwingLayoutNode;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MoleculeCountsNode
extends PComposite {
    private final WeakAcid solution;
    private final MagnifyingGlassNode magnifyingGlassNode;
    private final NumberNode.IntegerNode dotsHA;
    private final NumberNode.IntegerNode dotsA;
    private final NumberNode.IntegerNode dotsH3O;
    private final NumberNode.IntegerNode dotsOH;
    private final NumberNode.IntegerNode dotsH2O;
    private final NumberNode.IntegerNode imagesHA;
    private final NumberNode.IntegerNode imagesA;
    private final NumberNode.IntegerNode imagesH3O;
    private final NumberNode.IntegerNode imagesOH;
    private final NumberNode.IntegerNode imagesH2O;
    private final NumberNode.ScientificIntegerNode actualHA;
    private final NumberNode.ScientificIntegerNode actualA;
    private final NumberNode.ScientificIntegerNode actualH3O;
    private final NumberNode.ScientificIntegerNode actualOH;
    private final NumberNode.ScientificIntegerNode actualH2O;

    public MoleculeCountsNode(WeakAcid weakAcid, MagnifyingGlassNode magnifyingGlassNode, boolean bl) {
        this.solution = weakAcid;
        this.magnifyingGlassNode = magnifyingGlassNode;
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MoleculeCountsNode.this.update();
            }
        };
        weakAcid.addChangeListener(changeListener);
        magnifyingGlassNode.getDotsNode().addChangeListener(changeListener);
        magnifyingGlassNode.getImagesNode().addChangeListener(changeListener);
        HTMLNode hTMLNode = new HTMLNode("H<i>A</i>");
        HTMLNode hTMLNode2 = new HTMLNode("<i>A</i><sup>-</sup>");
        HTMLNode hTMLNode3 = new HTMLNode("H<sub>3</sub>O<sup>+</sup>");
        HTMLNode hTMLNode4 = new HTMLNode("OH<sup>-</sup>");
        HTMLNode hTMLNode5 = new HTMLNode("H<sub>2</sub>O");
        this.dotsHA = new NumberNode.IntegerNode();
        this.dotsA = new NumberNode.IntegerNode();
        this.dotsH3O = new NumberNode.IntegerNode();
        this.dotsOH = new NumberNode.IntegerNode();
        this.dotsH2O = new NumberNode.IntegerNode();
        this.imagesHA = new NumberNode.IntegerNode();
        this.imagesA = new NumberNode.IntegerNode();
        this.imagesH3O = new NumberNode.IntegerNode();
        this.imagesOH = new NumberNode.IntegerNode();
        this.imagesH2O = new NumberNode.IntegerNode();
        this.actualHA = new NumberNode.ScientificIntegerNode();
        this.actualA = new NumberNode.ScientificIntegerNode();
        this.actualH3O = new NumberNode.ScientificIntegerNode();
        this.actualOH = new NumberNode.ScientificIntegerNode();
        this.actualH2O = new NumberNode.ScientificIntegerNode();
        PText pText = new PText("images:");
        PText pText2 = new PText("dots:");
        PText pText3 = new PText("actual:");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 65, 65, 65, 65, 65};
        SwingLayoutNode swingLayoutNode = new SwingLayoutNode(gridBagLayout);
        this.addChild(swingLayoutNode);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        swingLayoutNode.addChild(hTMLNode, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(hTMLNode2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(hTMLNode3, gridBagConstraints);
        if (bl) {
            ++gridBagConstraints.gridx;
            swingLayoutNode.addChild(hTMLNode4, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(hTMLNode5, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 2, 0, 2);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        swingLayoutNode.addChild(pText, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.imagesHA, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.imagesA, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.imagesH3O, gridBagConstraints);
        if (bl) {
            ++gridBagConstraints.gridx;
            swingLayoutNode.addChild(this.imagesOH, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.imagesH2O, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        swingLayoutNode.addChild(pText2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.dotsHA, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.dotsA, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.dotsH3O, gridBagConstraints);
        if (bl) {
            ++gridBagConstraints.gridx;
            swingLayoutNode.addChild(this.dotsOH, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.dotsH2O, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        swingLayoutNode.addChild(pText3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.actualHA, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.actualA, gridBagConstraints);
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.actualH3O, gridBagConstraints);
        if (bl) {
            ++gridBagConstraints.gridx;
            swingLayoutNode.addChild(this.actualOH, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        swingLayoutNode.addChild(this.actualH2O, gridBagConstraints);
        this.update();
    }

    private void update() {
        DotsNode dotsNode = this.magnifyingGlassNode.getDotsNode();
        this.dotsHA.setValue(dotsNode.getCountHA());
        this.dotsA.setValue(dotsNode.getCountA());
        this.dotsH3O.setValue(dotsNode.getCountH3O());
        this.dotsOH.setValue(dotsNode.getCountOH());
        this.dotsH2O.setValue(dotsNode.getCountH2O());
        ImagesNode imagesNode = this.magnifyingGlassNode.getImagesNode();
        this.imagesHA.setValue(imagesNode.getCountHA());
        this.imagesA.setValue(imagesNode.getCountA());
        this.imagesH3O.setValue(imagesNode.getCountH3O());
        this.imagesOH.setValue(imagesNode.getCountOH());
        this.imagesH2O.setValue(imagesNode.getCountH2O());
        this.actualHA.setValue(this.solution.getMoleculeCountHA());
        this.actualA.setValue(this.solution.getMoleculeCountA());
        this.actualH3O.setValue(this.solution.getMoleculeCountH3O());
        this.actualOH.setValue(this.solution.getMoleculeCountOH());
        this.actualH2O.setValue(this.solution.getMoleculeCountH2O());
    }
}

