/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlassNode;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MoleculeControls
extends JPanel {
    private final MagnifyingGlassNode magnifyingGlassNode;
    private final MagnifyingGlass magnifyingGlass;
    private final JRadioButton imagesRadioButton;
    private final JRadioButton dotsRadioButton;
    private final JCheckBox showH2OCheckBox;

    public MoleculeControls(final MagnifyingGlass magnifyingGlass, final MagnifyingGlassNode magnifyingGlassNode) {
        this.setBorder(new TitledBorder("Molecules"));
        this.magnifyingGlass = magnifyingGlass;
        magnifyingGlass.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MoleculeControls.this.updateControls();
            }
        });
        this.magnifyingGlassNode = magnifyingGlassNode;
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MoleculeControls.this.updateControls();
            }
        };
        magnifyingGlassNode.getImagesNode().addChangeListener(changeListener);
        magnifyingGlassNode.getDotsNode().addChangeListener(changeListener);
        this.imagesRadioButton = new JRadioButton("images");
        this.imagesRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (MoleculeControls.this.imagesRadioButton.isSelected()) {
                    magnifyingGlass.setMoleculeRepresentation(MagnifyingGlass.MoleculeRepresentation.IMAGES);
                }
            }
        });
        this.dotsRadioButton = new JRadioButton("dots");
        this.dotsRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (MoleculeControls.this.dotsRadioButton.isSelected()) {
                    magnifyingGlass.setMoleculeRepresentation(MagnifyingGlass.MoleculeRepresentation.DOTS);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.imagesRadioButton);
        buttonGroup.add(this.dotsRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("representation:"));
        jPanel.add(this.imagesRadioButton);
        jPanel.add(this.dotsRadioButton);
        String string = HTMLUtils.toHTMLString("show H<sub>2</sub>O molecules");
        this.showH2OCheckBox = new JCheckBox(string);
        this.showH2OCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                magnifyingGlassNode.getImagesNode().setH2OVisible(MoleculeControls.this.showH2OCheckBox.isSelected());
                magnifyingGlassNode.getDotsNode().setH2OVisible(MoleculeControls.this.showH2OCheckBox.isSelected());
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jPanel, n++, n2);
        easyGridBagLayout.addComponent(this.showH2OCheckBox, n, n2);
        this.updateControls();
    }

    private void updateControls() {
        this.imagesRadioButton.setSelected(this.magnifyingGlass.getMoleculeRepresentation() == MagnifyingGlass.MoleculeRepresentation.IMAGES);
        this.dotsRadioButton.setSelected(this.magnifyingGlass.getMoleculeRepresentation() == MagnifyingGlass.MoleculeRepresentation.DOTS);
        this.showH2OCheckBox.setSelected(this.magnifyingGlassNode.getImagesNode().isH2OVisible());
    }
}

