/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.DotsNode;
import edu.colorado.phet.acidbasesolutions.prototype.ImagesNode;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcid;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MagnifyingGlassNode
extends PComposite {
    private static final Stroke GLASS_STROKE = new BasicStroke(18.0f);
    private static final Color GLASS_STROKE_COLOR = Color.BLACK;
    private static final Stroke HANDLE_STROKE = new BasicStroke(2.0f);
    private static final Color HANDLE_STROKE_COLOR = Color.BLACK;
    private static final Color HANDLE_FILL_COLOR = new Color(85, 55, 33);
    private final MagnifyingGlass magnifyingGlass;
    private final WeakAcid solution;
    private final PPath handleNode;
    private final RoundRectangle2D handlePath;
    private final PPath circleNode;
    private final Ellipse2D circlePath;
    private final DotsNode dotsNode;
    private final ImagesNode imagesNode;

    public MagnifyingGlassNode(MagnifyingGlass magnifyingGlass, WeakAcid weakAcid, boolean bl) {
        this.magnifyingGlass = magnifyingGlass;
        magnifyingGlass.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MagnifyingGlassNode.this.update();
            }
        });
        this.solution = weakAcid;
        weakAcid.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MagnifyingGlassNode.this.update();
            }
        });
        this.handlePath = new RoundRectangle2D.Double();
        this.handleNode = new PPath();
        this.handleNode.setStroke(HANDLE_STROKE);
        this.handleNode.setStrokePaint(HANDLE_STROKE_COLOR);
        this.handleNode.setPaint(HANDLE_FILL_COLOR);
        this.addChild(this.handleNode);
        this.circlePath = new Ellipse2D.Double();
        this.circleNode = new PClip();
        this.circleNode.setStroke(GLASS_STROKE);
        this.circleNode.setStrokePaint(GLASS_STROKE_COLOR);
        this.addChild(this.circleNode);
        this.dotsNode = new DotsNode(weakAcid, magnifyingGlass, bl);
        this.circleNode.addChild(this.dotsNode);
        this.imagesNode = new ImagesNode(weakAcid, magnifyingGlass, bl);
        this.circleNode.addChild(this.imagesNode);
        this.update();
    }

    public DotsNode getDotsNode() {
        return this.dotsNode;
    }

    public ImagesNode getImagesNode() {
        return this.imagesNode;
    }

    private void update() {
        double d = this.magnifyingGlass.getDiameter();
        this.circlePath.setFrame(-d / 2.0, -d / 2.0, d, d);
        this.circleNode.setPathTo(this.circlePath);
        this.circleNode.setPaint(this.solution.getColor());
        double d2 = d / 8.0;
        double d3 = d / 2.25;
        this.handlePath.setRoundRect(-d2 / 2.0, 0.0, d2, d3, 40.0, 40.0);
        this.handleNode.setPathTo(this.handlePath);
        this.handleNode.getTransform().setToIdentity();
        PAffineTransform pAffineTransform = new PAffineTransform();
        pAffineTransform.rotate(-0.7853981633974483);
        pAffineTransform.translate(0.0, d / 2.0);
        this.handleNode.setTransform(pAffineTransform);
        this.dotsNode.setVisible(this.magnifyingGlass.getMoleculeRepresentation() == MagnifyingGlass.MoleculeRepresentation.DOTS);
        this.imagesNode.setVisible(this.magnifyingGlass.getMoleculeRepresentation() == MagnifyingGlass.MoleculeRepresentation.IMAGES);
    }
}

