/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlass;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MagnifyingGlassControls
extends JPanel {
    private final MagnifyingGlass magnifyingGlass;
    private final LinearValueControl diameterControl;

    public MagnifyingGlassControls(final MagnifyingGlass magnifyingGlass) {
        this.setBorder(new TitledBorder("Magnifying glass"));
        this.magnifyingGlass = magnifyingGlass;
        magnifyingGlass.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MagnifyingGlassControls.this.updateControls();
            }
        });
        IntegerRange integerRange = MGPConstants.MAGNIFYING_GLASS_DIAMETER_RANGE;
        this.diameterControl = new LinearValueControl(integerRange.getMin(), integerRange.getMax(), "diameter:", "##0", "");
        this.diameterControl.setBorder(new EtchedBorder());
        this.diameterControl.setUpDownArrowDelta(1.0);
        this.diameterControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                magnifyingGlass.setDiameter((int)MagnifyingGlassControls.this.diameterControl.getValue());
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this.diameterControl, n, n2++);
        this.updateControls();
    }

    private void updateControls() {
        this.diameterControl.setValue(this.magnifyingGlass.getDiameter());
    }
}

