/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.BeakerControls;
import edu.colorado.phet.acidbasesolutions.prototype.ColorControls;
import edu.colorado.phet.acidbasesolutions.prototype.DotControls;
import edu.colorado.phet.acidbasesolutions.prototype.ImageControls;
import edu.colorado.phet.acidbasesolutions.prototype.MGPCanvas;
import edu.colorado.phet.acidbasesolutions.prototype.MGPModel;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlassControls;
import edu.colorado.phet.acidbasesolutions.prototype.MoleculeControls;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcidControls;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MGPControlPanel
extends ControlPanel {
    private final MGPModel model;
    private final WeakAcidControls weakAcidControls;
    private final MoleculeControls moleculeControls;
    private final DotControls dotControls;
    private final ImageControls imageControls;
    private final ColorControls colorControls;
    private final BeakerControls beakerControls;
    private final MagnifyingGlassControls magnifyingGlassControls;

    public MGPControlPanel(JFrame jFrame, MGPCanvas mGPCanvas, MGPModel mGPModel, boolean bl) {
        this.model = mGPModel;
        mGPModel.getMagnifyingGlass().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MGPControlPanel.this.updateVisibility();
            }
        });
        this.weakAcidControls = new WeakAcidControls(jFrame, mGPModel.getSolution());
        this.moleculeControls = new MoleculeControls(mGPModel.getMagnifyingGlass(), mGPCanvas.getMagnifyingGlassNode());
        this.dotControls = new DotControls(jFrame, mGPCanvas.getMagnifyingGlassNode().getDotsNode());
        this.imageControls = new ImageControls(mGPCanvas.getMagnifyingGlassNode().getImagesNode());
        this.colorControls = new ColorControls(jFrame, mGPModel.getSolution(), mGPCanvas.getMagnifyingGlassNode().getDotsNode(), mGPCanvas, bl);
        this.beakerControls = new BeakerControls(jFrame, mGPModel.getBeaker());
        this.magnifyingGlassControls = new MagnifyingGlassControls(mGPModel.getMagnifyingGlass());
        JPanel jPanel = new JPanel();
        this.addControl(jPanel);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        easyGridBagLayout.setFill(2);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this.weakAcidControls, n++, n2);
        easyGridBagLayout.addComponent(this.moleculeControls, n++, n2);
        if (bl) {
            easyGridBagLayout.addComponent(this.dotControls, n++, n2);
            easyGridBagLayout.addComponent(this.imageControls, n++, n2);
            easyGridBagLayout.addComponent(this.colorControls, n++, n2);
            easyGridBagLayout.addComponent(this.beakerControls, n++, n2);
            easyGridBagLayout.addComponent(this.magnifyingGlassControls, n++, n2);
        }
        this.addControlFullWidth(jPanel);
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.dotControls.setVisible(this.model.getMagnifyingGlass().getMoleculeRepresentation() == MagnifyingGlass.MoleculeRepresentation.DOTS);
        this.imageControls.setVisible(this.model.getMagnifyingGlass().getMoleculeRepresentation() == MagnifyingGlass.MoleculeRepresentation.IMAGES);
    }
}

