/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.BeakerNode;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.acidbasesolutions.prototype.MGPModel;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlassNode;
import edu.colorado.phet.acidbasesolutions.prototype.MoleculeCountsNode;
import edu.colorado.phet.acidbasesolutions.prototype.PHMeterNode;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcidReactionEquationNode;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Dimension2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class MGPCanvas
extends PhetPCanvas {
    private final PNode rootNode;
    private final MagnifyingGlassNode magnifyingGlassNode;
    private final BeakerNode beakerNode;
    private final PHMeterNode pHMeterNode;
    private final PNode reactionEquationNode;
    private final MoleculeCountsNode countsNode;

    public MGPCanvas(MGPModel mGPModel, boolean bl) {
        super(MGPConstants.CANVAS_SIZE);
        this.setBackground(MGPConstants.CANVAS_COLOR);
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        this.magnifyingGlassNode = new MagnifyingGlassNode(mGPModel.getMagnifyingGlass(), mGPModel.getSolution(), bl);
        this.magnifyingGlassNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    MGPCanvas.this.updateLayout();
                }
            }
        });
        this.beakerNode = new BeakerNode(mGPModel.getBeaker(), mGPModel.getSolution(), this.magnifyingGlassNode, bl);
        this.beakerNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    MGPCanvas.this.updateLayout();
                }
            }
        });
        this.pHMeterNode = new PHMeterNode(mGPModel.getSolution());
        this.reactionEquationNode = new WeakAcidReactionEquationNode();
        this.reactionEquationNode.scale(1.2);
        this.countsNode = new MoleculeCountsNode(mGPModel.getSolution(), this.magnifyingGlassNode, bl);
        this.countsNode.setOffset(20.0, 20.0);
        this.countsNode.scale(1.5);
        this.addChild(this.beakerNode);
        this.addChild(this.magnifyingGlassNode);
        this.addChild(this.pHMeterNode);
        this.addChild(this.reactionEquationNode);
        if (bl) {
            this.addChild(this.countsNode);
        }
    }

    public MagnifyingGlassNode getMagnifyingGlassNode() {
        return this.magnifyingGlassNode;
    }

    private void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    public void updateLayout() {
        super.updateLayout();
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() == 0.0 || dimension2D.getHeight() == 0.0) {
            return;
        }
        double d = dimension2D.getWidth() / 2.0 - this.reactionEquationNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = dimension2D.getHeight() - this.reactionEquationNode.getFullBoundsReference().getHeight() - 30.0;
        this.reactionEquationNode.setOffset(d, d2);
        d = this.reactionEquationNode.getFullBoundsReference().getCenterX() - this.beakerNode.getFullBoundsReference().getWidth() / 2.0 - PNodeLayoutUtils.getOriginXOffset(this.beakerNode);
        d2 = this.reactionEquationNode.getFullBoundsReference().getMinY() - this.beakerNode.getFullBoundsReference().getHeight() - PNodeLayoutUtils.getOriginYOffset(this.beakerNode) - 20.0;
        this.beakerNode.setOffset(d, d2);
        this.magnifyingGlassNode.setOffset(d, d2);
        d = this.beakerNode.getFullBoundsReference().getMinX() + 50.0;
        d2 = this.beakerNode.getFullBoundsReference().getMinY() - 20.0;
        this.pHMeterNode.setOffset(d, d2);
    }
}

