/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.IMoleculeCountStrategy;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.prototype.MoleculesNode;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcid;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.awt.geom.Point2D;

class ImagesNode
extends MoleculesNode {
    private double imageScale = MGPConstants.IMAGE_SCALE_RANGE.getDefault();

    public ImagesNode(WeakAcid weakAcid, MagnifyingGlass magnifyingGlass, boolean bl) {
        super(weakAcid, magnifyingGlass, MGPConstants.MAX_IMAGES_RANGE.getDefault(), MGPConstants.MAX_H2O_IMAGES_RANGE.getDefault(), (float)MGPConstants.IMAGE_TRANSPARENCY_RANGE.getDefault(), new IMoleculeCountStrategy.ConcentrationMoleculeCountStrategy(), new IMoleculeCountStrategy.ConstantMoleculeCountStrategy(), bl);
        this.updateNumberOfMolecules();
    }

    public double getImageScale() {
        return this.imageScale;
    }

    public void setImageScale(double d) {
        if (d != this.imageScale) {
            this.imageScale = d;
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                PNode pNode = this.getChild(i);
                if (!(pNode instanceof MoleculesNode.MoleculeParentNode)) continue;
                ImagesNode.updateScale(pNode, d);
            }
            this.fireStateChanged();
        }
    }

    private static void updateScale(PNode pNode, double d) {
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            PNode pNode2 = pNode.getChild(i);
            if (!(pNode2 instanceof ImageNode)) continue;
            ((ImageNode)pNode2).setScale(d);
        }
    }

    protected void updateTransparency(PNode pNode, float f) {
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            PNode pNode2 = pNode.getChild(i);
            if (!(pNode2 instanceof ImageNode)) continue;
            ((ImageNode)pNode2).setTransparency(f);
        }
    }

    protected void updateNumberOfMoleculeNodes() {
        this.updateNumberOfMoleculeNodes(this.getParentHA(), this.getCountHA(), this.imageScale, this.getMoleculeTransparency(), MGPConstants.HA_IMAGE);
        this.updateNumberOfMoleculeNodes(this.getParentA(), this.getCountA(), this.imageScale, this.getMoleculeTransparency(), MGPConstants.A_MINUS_IMAGE);
        this.updateNumberOfMoleculeNodes(this.getParentH3O(), this.getCountH3O(), this.imageScale, this.getMoleculeTransparency(), MGPConstants.H3O_PLUS_IMAGE);
        this.updateNumberOfMoleculeNodes(this.getParentOH(), this.getCountOH(), this.imageScale, this.getMoleculeTransparency(), MGPConstants.OH_MINUS_IMAGE);
        this.updateNumberOfMoleculeNodes(this.getParentH2O(), this.getCountH2O(), this.imageScale, this.getMoleculeTransparency(), MGPConstants.H2O_IMAGE);
    }

    private void updateNumberOfMoleculeNodes(PNode pNode, int n, double d, float f, Image image) {
        while (n < pNode.getChildrenCount() && n >= 0) {
            pNode.removeChild(pNode.getChildrenCount() - 1);
        }
        while (n > pNode.getChildrenCount()) {
            ImageNode imageNode = new ImageNode(image, d, f);
            Point2D point2D = this.getRandomPoint();
            double d2 = point2D.getX() - imageNode.getFullBoundsReference().getWidth() / 2.0;
            double d3 = point2D.getY() - imageNode.getFullBoundsReference().getHeight() / 2.0;
            imageNode.setOffset(d2, d3);
            pNode.addChild(imageNode);
        }
        assert (n == pNode.getChildrenCount());
    }

    private static class ImageNode
    extends PImage {
        public ImageNode(Image image, double d, float f) {
            super(image);
            this.setScale(d);
            this.setTransparency(f);
        }
    }
}

