/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.ImagesNode;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ImageControls
extends JPanel {
    private final ImagesNode imagesNode;
    private final LinearValueControl maxMoleculesControl;
    private final LinearValueControl scaleControl;
    private final LinearValueControl transparencyControl;
    private final LinearValueControl maxH2OControl;
    private final LinearValueControl h2oTransparencyControl;

    public ImageControls(final ImagesNode imagesNode) {
        this.setBorder(new TitledBorder("Images"));
        this.imagesNode = imagesNode;
        imagesNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ImageControls.this.updateControls();
            }
        });
        IntegerRange integerRange = MGPConstants.MAX_IMAGES_RANGE;
        this.maxMoleculesControl = new LinearValueControl(integerRange.getMin(), integerRange.getMax(), "max images:", "####0", "");
        this.maxMoleculesControl.setBorder(new EtchedBorder());
        this.maxMoleculesControl.setUpDownArrowDelta(1.0);
        this.maxMoleculesControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                imagesNode.setMaxMolecules((int)ImageControls.this.maxMoleculesControl.getValue());
            }
        });
        DoubleRange doubleRange = MGPConstants.IMAGE_SCALE_RANGE;
        this.scaleControl = new LinearValueControl(doubleRange.getMin(), doubleRange.getMax(), "scale:", "0.00", "");
        this.scaleControl.setBorder(new EtchedBorder());
        this.scaleControl.setUpDownArrowDelta(0.01);
        this.scaleControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                imagesNode.setImageScale(ImageControls.this.scaleControl.getValue());
            }
        });
        DoubleRange doubleRange2 = MGPConstants.DOT_TRANSPARENCY_RANGE;
        this.transparencyControl = new LinearValueControl(doubleRange2.getMin(), doubleRange2.getMax(), "transparency:", "0.00", "");
        this.transparencyControl.setBorder(new EtchedBorder());
        this.transparencyControl.setUpDownArrowDelta(0.01);
        this.transparencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                imagesNode.setMoleculeTransparency((float)ImageControls.this.transparencyControl.getValue());
            }
        });
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(this.transparencyControl.getMinimum()), new JLabel("invisible"));
        hashtable.put(new Double(this.transparencyControl.getMaximum()), new JLabel("opaque"));
        this.transparencyControl.setTickLabels(hashtable);
        IntegerRange integerRange2 = MGPConstants.MAX_H2O_IMAGES_RANGE;
        String string = HTMLUtils.toHTMLString("H<sub>2</sub>O images:");
        this.maxH2OControl = new LinearValueControl(integerRange2.getMin(), integerRange2.getMax(), string, "####0", "");
        this.maxH2OControl.setBorder(new EtchedBorder());
        this.maxH2OControl.setUpDownArrowDelta(1.0);
        this.maxH2OControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                imagesNode.setMaxH2O((int)ImageControls.this.maxH2OControl.getValue());
            }
        });
        DoubleRange doubleRange3 = MGPConstants.DOT_TRANSPARENCY_RANGE;
        String string2 = HTMLUtils.toHTMLString("H<sub>2</sub>O transparency:");
        this.h2oTransparencyControl = new LinearValueControl(doubleRange3.getMin(), doubleRange3.getMax(), string2, "0.00", "");
        this.h2oTransparencyControl.setBorder(new EtchedBorder());
        this.h2oTransparencyControl.setUpDownArrowDelta(0.01);
        this.h2oTransparencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                imagesNode.setH2OTransparency((float)ImageControls.this.h2oTransparencyControl.getValue());
            }
        });
        Hashtable<Double, JLabel> hashtable2 = new Hashtable<Double, JLabel>();
        hashtable2.put(new Double(this.h2oTransparencyControl.getMinimum()), new JLabel("invisible"));
        hashtable2.put(new Double(this.h2oTransparencyControl.getMaximum()), new JLabel("opaque"));
        this.h2oTransparencyControl.setTickLabels(hashtable2);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this.maxMoleculesControl, n++, n2);
        easyGridBagLayout.addComponent(this.scaleControl, n++, n2);
        easyGridBagLayout.addComponent(this.transparencyControl, n++, n2);
        easyGridBagLayout.addComponent(this.maxH2OControl, n++, n2);
        easyGridBagLayout.addComponent(this.h2oTransparencyControl, n++, n2);
        this.updateControls();
    }

    private void updateControls() {
        this.maxMoleculesControl.setValue(this.imagesNode.getMaxMolecules());
        this.maxH2OControl.setValue(this.imagesNode.getMaxH2O());
        this.scaleControl.setValue(this.imagesNode.getImageScale());
        this.transparencyControl.setValue(this.imagesNode.getMoleculeTransparency());
        this.h2oTransparencyControl.setValue(this.imagesNode.getH2OTransparency());
    }
}

