/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.IMoleculeCountStrategy;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.acidbasesolutions.prototype.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.prototype.MoleculesNode;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcid;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

class DotsNode
extends MoleculesNode {
    private double dotDiameter = MGPConstants.DOT_DIAMETER_RANGE.getDefault();
    private Color colorHA = MGPConstants.COLOR_HA;
    private Color colorA = MGPConstants.COLOR_A_MINUS;
    private Color colorH3O = MGPConstants.COLOR_H3O_PLUS;
    private Color colorOH = MGPConstants.COLOR_OH_MINUS;
    private Color colorH2O = MGPConstants.COLOR_H2O;

    public DotsNode(WeakAcid weakAcid, MagnifyingGlass magnifyingGlass, boolean bl) {
        super(weakAcid, magnifyingGlass, MGPConstants.MAX_DOTS_RANGE.getDefault(), MGPConstants.MAX_H2O_DOTS_RANGE.getDefault(), (float)MGPConstants.DOT_TRANSPARENCY_RANGE.getDefault(), new IMoleculeCountStrategy.ConcentrationMoleculeCountStrategy(), new IMoleculeCountStrategy.ConstantMoleculeCountStrategy(), bl);
        this.updateNumberOfMolecules();
    }

    public double getDotDiameter() {
        return this.dotDiameter;
    }

    public void setDotDiameter(double d) {
        if (d != this.dotDiameter) {
            this.dotDiameter = d;
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                PNode pNode = this.getChild(i);
                if (!(pNode instanceof MoleculesNode.MoleculeParentNode)) continue;
                DotsNode.updateDiameter(pNode, d);
            }
            this.fireStateChanged();
        }
    }

    public Color getColorHA() {
        return this.colorHA;
    }

    public void setColorHA(Color color) {
        if (!color.equals(this.colorHA)) {
            this.colorHA = color;
            DotsNode.updateDotColor(color, this.getParentHA());
            this.fireStateChanged();
        }
    }

    public Color getColorA() {
        return this.colorA;
    }

    public void setColorA(Color color) {
        if (!color.equals(this.colorA)) {
            this.colorA = color;
            DotsNode.updateDotColor(color, this.getParentA());
            this.fireStateChanged();
        }
    }

    public Color getColorH3O() {
        return this.colorH3O;
    }

    public void setColorH3O(Color color) {
        if (!color.equals(this.colorH3O)) {
            this.colorH3O = color;
            DotsNode.updateDotColor(color, this.getParentH3O());
            this.fireStateChanged();
        }
    }

    public Color getColorOH() {
        return this.colorOH;
    }

    public void setColorOH(Color color) {
        if (!color.equals(this.colorOH)) {
            this.colorOH = color;
            DotsNode.updateDotColor(color, this.getParentOH());
            this.fireStateChanged();
        }
    }

    public Color getColorH2O() {
        return this.colorH2O;
    }

    public void setColorH2O(Color color) {
        if (!color.equals(this.colorH2O)) {
            this.colorH2O = color;
            DotsNode.updateDotColor(color, this.getParentH2O());
            this.fireStateChanged();
        }
    }

    private static void updateDiameter(PNode pNode, double d) {
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            PNode pNode2 = pNode.getChild(i);
            if (!(pNode2 instanceof DotNode)) continue;
            ((DotNode)pNode2).setDiameter(d);
        }
    }

    protected void updateTransparency(PNode pNode, float f) {
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            PNode pNode2 = pNode.getChild(i);
            if (!(pNode2 instanceof DotNode)) continue;
            ((DotNode)pNode2).setTransparency(f);
        }
    }

    private static void updateDotColor(Color color, PNode pNode) {
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            PNode pNode2 = pNode.getChild(i);
            if (!(pNode2 instanceof DotNode)) continue;
            ((DotNode)pNode2).setPaint(color);
        }
    }

    protected void updateNumberOfMoleculeNodes() {
        this.updateNumberOfMoleculeNodes(this.getParentHA(), this.getCountHA(), this.dotDiameter, this.getMoleculeTransparency(), this.colorHA);
        this.updateNumberOfMoleculeNodes(this.getParentA(), this.getCountA(), this.dotDiameter, this.getMoleculeTransparency(), this.colorA);
        this.updateNumberOfMoleculeNodes(this.getParentH3O(), this.getCountH3O(), this.dotDiameter, this.getMoleculeTransparency(), this.colorH3O);
        this.updateNumberOfMoleculeNodes(this.getParentOH(), this.getCountOH(), this.dotDiameter, this.getMoleculeTransparency(), this.colorOH);
        this.updateNumberOfMoleculeNodes(this.getParentH2O(), this.getCountH2O(), this.dotDiameter, this.getH2OTransparency(), this.colorH2O);
    }

    private void updateNumberOfMoleculeNodes(PNode pNode, int n, double d, float f, Color color) {
        while (n < pNode.getChildrenCount() && n >= 0) {
            pNode.removeChild(pNode.getChildrenCount() - 1);
        }
        while (n > pNode.getChildrenCount()) {
            DotNode dotNode = new DotNode(d, color, f);
            Point2D point2D = this.getRandomPoint();
            double d2 = point2D.getX() - dotNode.getFullBoundsReference().getWidth() / 2.0;
            double d3 = point2D.getY() - dotNode.getFullBoundsReference().getHeight() / 2.0;
            dotNode.setOffset(d2, d3);
            pNode.addChild(dotNode);
        }
        assert (n == pNode.getChildrenCount());
    }

    private static class DotNode
    extends PPath {
        private Ellipse2D ellipse = new Ellipse2D.Double();

        public DotNode(double d, Color color, float f) {
            this.setTransparency(f);
            this.setPaint(color);
            this.setStroke(null);
            this.setDiameter(d);
        }

        public void setDiameter(double d) {
            this.ellipse.setFrame(-d / 2.0, -d / 2.0, d, d);
            this.setPathTo(this.ellipse);
        }
    }
}

