/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.DotsNode;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DotControls
extends JPanel {
    private final DotsNode dotsNode;
    private final LinearValueControl maxMoleculesControl;
    private final LinearValueControl diameterControl;
    private final LinearValueControl transparencyControl;
    private final LinearValueControl maxH2OControl;
    private final LinearValueControl h2oTransparencyControl;

    public DotControls(JFrame jFrame, final DotsNode dotsNode) {
        this.setBorder(new TitledBorder("Dots"));
        this.dotsNode = dotsNode;
        dotsNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DotControls.this.updateControls();
            }
        });
        IntegerRange integerRange = MGPConstants.MAX_DOTS_RANGE;
        this.maxMoleculesControl = new LinearValueControl(integerRange.getMin(), integerRange.getMax(), "max dots:", "####0", "");
        this.maxMoleculesControl.setBorder(new EtchedBorder());
        this.maxMoleculesControl.setUpDownArrowDelta(1.0);
        this.maxMoleculesControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setMaxMolecules((int)DotControls.this.maxMoleculesControl.getValue());
            }
        });
        DoubleRange doubleRange = MGPConstants.DOT_DIAMETER_RANGE;
        this.diameterControl = new LinearValueControl(doubleRange.getMin(), doubleRange.getMax(), "diameter:", "#0", "");
        this.diameterControl.setBorder(new EtchedBorder());
        this.diameterControl.setUpDownArrowDelta(1.0);
        this.diameterControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setDotDiameter(DotControls.this.diameterControl.getValue());
            }
        });
        DoubleRange doubleRange2 = MGPConstants.DOT_TRANSPARENCY_RANGE;
        this.transparencyControl = new LinearValueControl(doubleRange2.getMin(), doubleRange2.getMax(), "transparency:", "0.00", "");
        this.transparencyControl.setBorder(new EtchedBorder());
        this.transparencyControl.setUpDownArrowDelta(0.01);
        this.transparencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setMoleculeTransparency((float)DotControls.this.transparencyControl.getValue());
            }
        });
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(this.transparencyControl.getMinimum()), new JLabel("invisible"));
        hashtable.put(new Double(this.transparencyControl.getMaximum()), new JLabel("opaque"));
        this.transparencyControl.setTickLabels(hashtable);
        IntegerRange integerRange2 = MGPConstants.MAX_H2O_DOTS_RANGE;
        String string = HTMLUtils.toHTMLString("H<sub>2</sub>O dots:");
        this.maxH2OControl = new LinearValueControl(integerRange2.getMin(), integerRange2.getMax(), string, "####0", "");
        this.maxH2OControl.setBorder(new EtchedBorder());
        this.maxH2OControl.setUpDownArrowDelta(1.0);
        this.maxH2OControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setMaxH2O((int)DotControls.this.maxH2OControl.getValue());
            }
        });
        DoubleRange doubleRange3 = MGPConstants.DOT_TRANSPARENCY_RANGE;
        String string2 = HTMLUtils.toHTMLString("H<sub>2</sub>O transparency:");
        this.h2oTransparencyControl = new LinearValueControl(doubleRange3.getMin(), doubleRange3.getMax(), string2, "0.00", "");
        this.h2oTransparencyControl.setBorder(new EtchedBorder());
        this.h2oTransparencyControl.setUpDownArrowDelta(0.01);
        this.h2oTransparencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setH2OTransparency((float)DotControls.this.h2oTransparencyControl.getValue());
            }
        });
        Hashtable<Double, JLabel> hashtable2 = new Hashtable<Double, JLabel>();
        hashtable2.put(new Double(this.h2oTransparencyControl.getMinimum()), new JLabel("invisible"));
        hashtable2.put(new Double(this.h2oTransparencyControl.getMaximum()), new JLabel("opaque"));
        this.h2oTransparencyControl.setTickLabels(hashtable2);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this.maxMoleculesControl, n++, n2);
        easyGridBagLayout.addComponent(this.diameterControl, n++, n2);
        easyGridBagLayout.addComponent(this.transparencyControl, n++, n2);
        easyGridBagLayout.addComponent(this.maxH2OControl, n++, n2);
        easyGridBagLayout.addComponent(this.h2oTransparencyControl, n++, n2);
        this.updateControls();
    }

    private void updateControls() {
        this.maxMoleculesControl.setValue(this.dotsNode.getMaxMolecules());
        this.diameterControl.setValue(this.dotsNode.getDotDiameter());
        this.transparencyControl.setValue(this.dotsNode.getMoleculeTransparency());
        this.maxH2OControl.setValue(this.dotsNode.getMaxH2O());
        this.h2oTransparencyControl.setValue(this.dotsNode.getH2OTransparency());
    }
}

