/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.DotsNode;
import edu.colorado.phet.acidbasesolutions.prototype.WeakAcid;
import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.umd.cs.piccolo.PCanvas;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ColorControls
extends JPanel {
    private final WeakAcid weakAcid;
    private final DotsNode dotsNode;
    private final PCanvas canvas;
    private final ColorControl solutionColorControl;
    private final ColorControl colorHAControl;
    private final ColorControl colorAControl;
    private final ColorControl colorH3OControl;
    private final ColorControl colorOHControl;
    private final ColorControl colorH2OControl;
    private final ColorControl canvasColorControl;

    public ColorControls(JFrame jFrame, final WeakAcid weakAcid, final DotsNode dotsNode, final PCanvas pCanvas, boolean bl) {
        this.setBorder(new TitledBorder("Colors"));
        this.weakAcid = weakAcid;
        weakAcid.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColorControls.this.updateControls();
            }
        });
        this.dotsNode = dotsNode;
        dotsNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColorControls.this.updateControls();
            }
        });
        this.canvas = pCanvas;
        pCanvas.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("background")) {
                    ColorControls.this.updateControls();
                }
            }
        });
        this.solutionColorControl = new ColorControl(jFrame, "solution color:", weakAcid.getColor());
        this.solutionColorControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                weakAcid.setColor(ColorControls.this.solutionColorControl.getColor());
            }
        });
        this.colorHAControl = new ColorControl(jFrame, HTMLUtils.toHTMLString("H<i>A</i>"), dotsNode.getColorHA());
        this.colorHAControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setColorHA(ColorControls.this.colorHAControl.getColor());
            }
        });
        this.colorAControl = new ColorControl(jFrame, HTMLUtils.toHTMLString("<i>A</i><sup>-</sup>"), dotsNode.getColorA());
        this.colorAControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setColorA(ColorControls.this.colorAControl.getColor());
            }
        });
        this.colorH3OControl = new ColorControl(jFrame, HTMLUtils.toHTMLString("H<sub>3</sub>O<sup>+</sup>"), dotsNode.getColorH3O());
        this.colorH3OControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setColorH3O(ColorControls.this.colorH3OControl.getColor());
            }
        });
        this.colorOHControl = new ColorControl(jFrame, HTMLUtils.toHTMLString("OH<sup>-</sup>"), dotsNode.getColorOH());
        this.colorOHControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setColorOH(ColorControls.this.colorOHControl.getColor());
            }
        });
        this.colorH2OControl = new ColorControl(jFrame, HTMLUtils.toHTMLString("H<sub>2</sub>O"), dotsNode.getColorH2O());
        this.colorH2OControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                dotsNode.setColorH2O(ColorControls.this.colorH2OControl.getColor());
            }
        });
        this.canvasColorControl = new ColorControl(jFrame, "canvas color:", pCanvas.getBackground());
        this.canvasColorControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                pCanvas.setBackground(ColorControls.this.canvasColorControl.getColor());
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this.solutionColorControl, n++, n2);
        easyGridBagLayout.addComponent(this.colorHAControl, n++, n2);
        easyGridBagLayout.addComponent(this.colorAControl, n++, n2);
        easyGridBagLayout.addComponent(this.colorH3OControl, n++, n2);
        if (bl) {
            easyGridBagLayout.addComponent(this.colorOHControl, n++, n2);
        }
        easyGridBagLayout.addComponent(this.colorH2OControl, n++, n2);
        easyGridBagLayout.addComponent(this.canvasColorControl, n++, n2);
        this.updateControls();
    }

    private void updateControls() {
        this.solutionColorControl.setColor(this.weakAcid.getColor());
        this.colorHAControl.setColor(this.dotsNode.getColorHA());
        this.colorAControl.setColor(this.dotsNode.getColorA());
        this.colorH3OControl.setColor(this.dotsNode.getColorH3O());
        this.colorOHControl.setColor(this.dotsNode.getColorOH());
        this.colorH2OControl.setColor(this.dotsNode.getColorH2O());
        this.canvasColorControl.setColor(this.canvas.getBackground());
    }
}

