/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.prototype;

import edu.colorado.phet.acidbasesolutions.prototype.Beaker;
import edu.colorado.phet.acidbasesolutions.prototype.MGPConstants;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class BeakerControls
extends JPanel {
    private final Beaker beaker;
    private final LinearValueControl widthControl;
    private final LinearValueControl heightControl;

    public BeakerControls(JFrame jFrame, final Beaker beaker) {
        this.setBorder(new TitledBorder("Beaker"));
        this.beaker = beaker;
        beaker.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BeakerControls.this.updateControls();
            }
        });
        IntegerRange integerRange = MGPConstants.BEAKER_WIDTH_RANGE;
        this.widthControl = new LinearValueControl(integerRange.getMin(), integerRange.getMax(), "width:", "##0", "");
        this.widthControl.setBorder(new EtchedBorder());
        this.widthControl.setUpDownArrowDelta(1.0);
        this.widthControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                beaker.setWidth((int)BeakerControls.this.widthControl.getValue());
            }
        });
        IntegerRange integerRange2 = MGPConstants.BEAKER_HEIGHT_RANGE;
        this.heightControl = new LinearValueControl(integerRange2.getMin(), integerRange2.getMax(), "height:", "##0", "");
        this.heightControl.setBorder(new EtchedBorder());
        this.heightControl.setUpDownArrowDelta(1.0);
        this.heightControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                beaker.setHeight((int)BeakerControls.this.heightControl.getValue());
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this.widthControl, n, n2++);
        n2 = 0;
        easyGridBagLayout.addComponent(this.heightControl, ++n, n2++);
        this.updateControls();
    }

    private void updateControls() {
        this.widthControl.setValue(this.beaker.getWidth());
        this.heightControl.setValue(this.beaker.getHeight());
    }
}

