/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.module;

import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.controls.FixedSolutionControls;
import edu.colorado.phet.acidbasesolutions.controls.TestControls;
import edu.colorado.phet.acidbasesolutions.controls.ViewControls;
import edu.colorado.phet.acidbasesolutions.model.ABSModel;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.PureWaterSolution;
import edu.colorado.phet.acidbasesolutions.module.ABSCanvas;
import edu.colorado.phet.acidbasesolutions.module.ABSModule;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import java.awt.Insets;

public class IntroductionModule
extends ABSModule {
    private final ABSModel model;
    private final ABSCanvas canvas;
    private final IntroductionControlPanel controlPanel;

    public IntroductionModule(boolean bl) {
        super(ABSSimSharing.UserComponents.introductionTab, ABSStrings.TEST_SOLUTION);
        ABSModel.SolutionFactory solutionFactory = new ABSModel.SolutionFactory(){

            public AqueousSolution createSolution() {
                return new PureWaterSolution();
            }
        };
        this.model = new ABSModel(solutionFactory);
        this.canvas = new ABSCanvas(this.model, bl);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new IntroductionControlPanel(this, this.model);
        this.setControlPanel(this.controlPanel);
        this.reset();
    }

    public void reset() {
        this.model.reset();
    }

    private static class IntroductionControlPanel
    extends ControlPanel {
        public IntroductionControlPanel(Resettable resettable, ABSModel aBSModel) {
            this.setInsets(new Insets(5, 5, 5, 5));
            this.addControlFullWidth(new FixedSolutionControls(aBSModel));
            this.addControlFullWidth(new ViewControls(aBSModel));
            this.addControlFullWidth(new TestControls(aBSModel));
            this.addResetAllButton(resettable);
        }
    }
}

