/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.module;

import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.controls.CustomSolutionControls;
import edu.colorado.phet.acidbasesolutions.controls.TestControls;
import edu.colorado.phet.acidbasesolutions.controls.ViewControls;
import edu.colorado.phet.acidbasesolutions.model.ABSModel;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.WeakAcidSolution;
import edu.colorado.phet.acidbasesolutions.module.ABSCanvas;
import edu.colorado.phet.acidbasesolutions.module.ABSModule;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import java.awt.Insets;

public class CustomSolutionModule
extends ABSModule {
    private final ABSModel model;
    private final ABSCanvas canvas;
    private final CustomSolutionControlPanel controlPanel;

    public CustomSolutionModule(boolean bl) {
        super(ABSSimSharing.UserComponents.customSolutionTab, ABSStrings.CUSTOM_SOLUTION);
        ABSModel.SolutionFactory solutionFactory = new ABSModel.SolutionFactory(){

            public AqueousSolution createSolution() {
                return new WeakAcidSolution.CustomWeakAcidSolution();
            }
        };
        this.model = new ABSModel(solutionFactory);
        this.canvas = new ABSCanvas(this.model, bl);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new CustomSolutionControlPanel(this, this.model);
        this.setControlPanel(this.controlPanel);
        this.reset();
    }

    public void reset() {
        this.model.reset();
    }

    private static class CustomSolutionControlPanel
    extends ControlPanel {
        public CustomSolutionControlPanel(Resettable resettable, ABSModel aBSModel) {
            this.setInsets(new Insets(2, 5, 2, 5));
            this.addControlFullWidth(new CustomSolutionControls(aBSModel));
            this.addControlFullWidth(new ViewControls(aBSModel));
            this.addControlFullWidth(new TestControls(aBSModel));
            this.addResetAllButton(resettable);
        }
    }
}

