/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.module;

import edu.colorado.phet.acidbasesolutions.constants.ABSColors;
import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.model.ABSModel;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.acidbasesolutions.view.ABSConductivityTesterNode;
import edu.colorado.phet.acidbasesolutions.view.BeakerNode;
import edu.colorado.phet.acidbasesolutions.view.MagnifyingGlassNode;
import edu.colorado.phet.acidbasesolutions.view.PHColorKeyNode;
import edu.colorado.phet.acidbasesolutions.view.PHMeterNode;
import edu.colorado.phet.acidbasesolutions.view.PHPaperNode;
import edu.colorado.phet.acidbasesolutions.view.ReactionEquationNode;
import edu.colorado.phet.acidbasesolutions.view.graph.ConcentrationGraphNode;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Dimension2D;

public class ABSCanvas
extends PhetPCanvas {
    private final PNode rootNode;
    private boolean isPaperAlignedWithColorKey;

    public ABSCanvas(ABSModel aBSModel, boolean bl) {
        super(ABSConstants.CANVAS_RENDERING_SIZE);
        this.setBackground(ABSColors.CANVAS_BACKGROUND);
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        BeakerNode beakerNode = new BeakerNode(aBSModel.getBeaker());
        PHMeterNode pHMeterNode = new PHMeterNode(aBSModel.getPHMeter());
        MagnifyingGlassNode magnifyingGlassNode = new MagnifyingGlassNode(aBSModel.getMagnifyingGlass());
        ConcentrationGraphNode concentrationGraphNode = new ConcentrationGraphNode(aBSModel.getConcentrationGraph());
        ReactionEquationNode reactionEquationNode = new ReactionEquationNode(aBSModel.getReactionEquation());
        final PHPaperNode pHPaperNode = new PHPaperNode(aBSModel.getPHPaper());
        final PHColorKeyNode pHColorKeyNode = new PHColorKeyNode(aBSModel.getPHPaper());
        ABSConductivityTesterNode aBSConductivityTesterNode = new ABSConductivityTesterNode(aBSModel.getConductivityTester(), bl);
        this.addNode(pHMeterNode);
        this.addNode(pHColorKeyNode);
        this.addNode(pHPaperNode);
        this.addNode(aBSConductivityTesterNode);
        this.addNode(beakerNode);
        this.addNode(magnifyingGlassNode);
        this.addNode(concentrationGraphNode);
        this.addNode(reactionEquationNode);
        ((PNode)pHColorKeyNode).setOffset(ABSConstants.PH_COLOR_KEY_LOCATION);
        aBSModel.getPHPaper().addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void locationChanged() {
                boolean bl;
                boolean bl2 = bl = pHPaperNode.getFullBoundsReference().getMinX() < pHColorKeyNode.getFullBoundsReference().getMaxX() && pHPaperNode.getFullBoundsReference().getMaxX() > pHColorKeyNode.getFullBoundsReference().getMinX();
                if (bl != ABSCanvas.this.isPaperAlignedWithColorKey) {
                    SimSharingManager.sendUserMessage(ABSSimSharing.UserComponents.phPaper, UserComponentTypes.sprite, UserActions.moved, ParameterSet.parameterSet((IParameterKey)ABSSimSharing.ParameterKeys.isPaperAlignedWithColorKey, bl));
                    ABSCanvas.this.isPaperAlignedWithColorKey = bl;
                }
            }
        });
    }

    protected void addNode(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    protected void centerRootNode() {
        this.centerNode(this.rootNode);
    }

    protected void centerNode(PNode pNode) {
        if (pNode != null) {
            Dimension2D dimension2D = this.getWorldSize();
            PBounds pBounds = pNode.getFullBoundsReference();
            double d = (dimension2D.getWidth() - pBounds.getWidth()) / 2.0 - PNodeLayoutUtils.getOriginXOffset(pNode);
            double d2 = (dimension2D.getHeight() - pBounds.getHeight()) / 2.0 - PNodeLayoutUtils.getOriginYOffset(pNode);
            pNode.setOffset(d, d2);
        }
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() > 0.0 && dimension2D.getHeight() > 0.0) {
            this.centerRootNode();
        }
    }
}

