/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.BaseSolution;
import edu.colorado.phet.acidbasesolutions.model.Molecule;

public abstract class WeakBaseSolution
extends BaseSolution {
    public WeakBaseSolution(Molecule molecule, Molecule molecule2, double d, double d2) {
        super(molecule, molecule2, d, d2);
    }

    public double getSoluteConcentration() {
        return this.getConcentration() - this.getProductConcentration();
    }

    public double getProductConcentration() {
        double d = this.getStrength();
        double d2 = this.getConcentration();
        return (-d + Math.sqrt(d * d + 4.0 * d * d2)) / 2.0;
    }

    public double getH3OConcentration() {
        return WeakBaseSolution.getWaterEquilibriumConstant() / this.getOHConcentration();
    }

    public double getOHConcentration() {
        return this.getProductConcentration();
    }

    public double getH2OConcentration() {
        return WeakBaseSolution.getWaterConcentration() - this.getProductConcentration();
    }

    protected boolean isValidStrength(double d) {
        return ABSConstants.WEAK_STRENGTH_RANGE.contains(d);
    }

    public static class CustomWeakBaseSolution
    extends GenericWeakBaseSolution
    implements AqueousSolution.ICustomSolution {
        public CustomWeakBaseSolution() {
            this(ABSConstants.WEAK_STRENGTH_RANGE.getDefault(), ABSConstants.CONCENTRATION_RANGE.getDefault());
        }

        public CustomWeakBaseSolution(double d, double d2) {
            super(d, d2);
        }

        public void setStrength(double d) {
            super.setStrength(d);
        }

        public void setConcentration(double d) {
            super.setConcentration(d);
        }
    }

    public static abstract class GenericWeakBaseSolution
    extends WeakBaseSolution {
        public GenericWeakBaseSolution(double d, double d2) {
            super(new Molecule.GenericWeakBaseMolecule(), new Molecule.GenericWeakBaseProductMolecule(), d, d2);
        }
    }

    public static class TestWeakBaseSolution
    extends GenericWeakBaseSolution {
        public TestWeakBaseSolution() {
            super(ABSConstants.WEAK_STRENGTH_RANGE.getDefault(), ABSConstants.CONCENTRATION_RANGE.getDefault());
        }
    }
}

