/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.model.AcidSolution;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Molecule;

public abstract class WeakAcidSolution
extends AcidSolution {
    public WeakAcidSolution(Molecule molecule, Molecule molecule2, double d, double d2) {
        super(molecule, molecule2, d, d2);
    }

    public double getSoluteConcentration() {
        return this.getConcentration() - this.getH3OConcentration();
    }

    public double getProductConcentration() {
        return this.getH3OConcentration();
    }

    public double getH3OConcentration() {
        double d = this.getStrength();
        double d2 = this.getConcentration();
        return (-d + Math.sqrt(d * d + 4.0 * d * d2)) / 2.0;
    }

    public double getOHConcentration() {
        return WeakAcidSolution.getWaterEquilibriumConstant() / this.getH3OConcentration();
    }

    public double getH2OConcentration() {
        return WeakAcidSolution.getWaterConcentration() - this.getProductConcentration();
    }

    protected boolean isValidStrength(double d) {
        return ABSConstants.WEAK_STRENGTH_RANGE.contains(d);
    }

    public static class CustomWeakAcidSolution
    extends GenericWeakAcidSolution
    implements AqueousSolution.ICustomSolution {
        public CustomWeakAcidSolution() {
            this(ABSConstants.WEAK_STRENGTH_RANGE.getDefault(), ABSConstants.CONCENTRATION_RANGE.getDefault());
        }

        public CustomWeakAcidSolution(double d, double d2) {
            super(d, d2);
        }

        public void setStrength(double d) {
            super.setStrength(d);
        }

        public void setConcentration(double d) {
            super.setConcentration(d);
        }
    }

    public static abstract class GenericWeakAcidSolution
    extends WeakAcidSolution {
        public GenericWeakAcidSolution(double d, double d2) {
            super(new Molecule.GenericAcidMolecule(), new Molecule.GenericAcidProductMolecule(), d, d2);
        }
    }

    public static class TestWeakAcidSolution
    extends GenericWeakAcidSolution {
        public TestWeakAcidSolution() {
            super(ABSConstants.WEAK_STRENGTH_RANGE.getDefault(), ABSConstants.CONCENTRATION_RANGE.getDefault());
        }
    }
}

