/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.BaseSolution;
import edu.colorado.phet.acidbasesolutions.model.Molecule;

public abstract class StrongBaseSolution
extends BaseSolution {
    public StrongBaseSolution(Molecule molecule, Molecule molecule2, double d, double d2) {
        super(molecule, molecule2, d, d2);
    }

    public double getSoluteConcentration() {
        return 0.0;
    }

    public double getProductConcentration() {
        return this.getConcentration();
    }

    public double getH3OConcentration() {
        return StrongBaseSolution.getWaterEquilibriumConstant() / this.getOHConcentration();
    }

    public double getOHConcentration() {
        return this.getConcentration();
    }

    public double getH2OConcentration() {
        return StrongBaseSolution.getWaterConcentration();
    }

    protected boolean isValidStrength(double d) {
        return d > ABSConstants.WEAK_STRENGTH_RANGE.getMax();
    }

    public static class CustomStrongBaseSolution
    extends GenericStrongBaseSolution
    implements AqueousSolution.ICustomSolution {
        public CustomStrongBaseSolution() {
            this(ABSConstants.CONCENTRATION_RANGE.getDefault());
        }

        public CustomStrongBaseSolution(double d) {
            super(ABSConstants.STRONG_STRENGTH, d);
        }

        public void setStrength(double d) {
            super.setStrength(d);
        }

        public void setConcentration(double d) {
            super.setConcentration(d);
        }
    }

    public static abstract class GenericStrongBaseSolution
    extends StrongBaseSolution {
        public GenericStrongBaseSolution(double d, double d2) {
            super(new Molecule.GenericStrongBaseMolecule(), new Molecule.GenericStrongBaseProductMolecule(), d, d2);
        }
    }

    public static class TestStrongBaseSolution
    extends GenericStrongBaseSolution {
        public TestStrongBaseSolution() {
            super(ABSConstants.STRONG_STRENGTH, ABSConstants.CONCENTRATION_RANGE.getDefault());
        }
    }
}

