/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.model.AcidSolution;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Molecule;

public abstract class StrongAcidSolution
extends AcidSolution {
    public StrongAcidSolution(Molecule molecule, Molecule molecule2, double d, double d2) {
        super(molecule, molecule2, d, d2);
    }

    public double getSoluteConcentration() {
        return 0.0;
    }

    public double getProductConcentration() {
        return this.getConcentration();
    }

    public double getH3OConcentration() {
        return this.getConcentration();
    }

    public double getOHConcentration() {
        return StrongAcidSolution.getWaterEquilibriumConstant() / this.getH3OConcentration();
    }

    public double getH2OConcentration() {
        return StrongAcidSolution.getWaterConcentration() - this.getConcentration();
    }

    protected boolean isValidStrength(double d) {
        return d > ABSConstants.WEAK_STRENGTH_RANGE.getMax();
    }

    public static class CustomStrongAcidSolution
    extends GenericStrongAcidSolution
    implements AqueousSolution.ICustomSolution {
        public CustomStrongAcidSolution() {
            this(ABSConstants.CONCENTRATION_RANGE.getDefault());
        }

        public CustomStrongAcidSolution(double d) {
            super(ABSConstants.STRONG_STRENGTH, d);
        }

        public void setStrength(double d) {
            super.setStrength(d);
        }

        public void setConcentration(double d) {
            super.setConcentration(d);
        }
    }

    public static abstract class GenericStrongAcidSolution
    extends StrongAcidSolution {
        public GenericStrongAcidSolution(double d, double d2) {
            super(new Molecule.GenericAcidMolecule(), new Molecule.GenericAcidProductMolecule(), d, d2);
        }
    }

    public static class TestStrongAcidSolution
    extends GenericStrongAcidSolution {
        public TestStrongAcidSolution() {
            super(ABSConstants.STRONG_STRENGTH, ABSConstants.CONCENTRATION_RANGE.getDefault());
        }
    }
}

