/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import java.awt.geom.Point2D;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class SolutionRepresentation {
    private final EventListenerList listeners;
    private AqueousSolution solution;
    private Point2D location;
    private boolean visible;
    private final AqueousSolution.AqueousSolutionChangeListener solutionChangeListener;

    public SolutionRepresentation(AqueousSolution aqueousSolution, Point2D point2D, boolean bl) {
        this.solution = aqueousSolution;
        this.location = new Point2D.Double(point2D.getX(), point2D.getY());
        this.visible = bl;
        this.listeners = new EventListenerList();
        this.solutionChangeListener = new AqueousSolution.AqueousSolutionChangeListener(){

            public void concentrationChanged() {
                SolutionRepresentation.this.fireConcentrationChanged();
            }

            public void strengthChanged() {
                SolutionRepresentation.this.fireStrengthChanged();
            }
        };
        aqueousSolution.addAqueousSolutionChangeListener(this.solutionChangeListener);
    }

    public void setSolution(AqueousSolution aqueousSolution) {
        if (aqueousSolution != this.solution) {
            this.solution.removeAqueousSolutionChangeListener(this.solutionChangeListener);
            this.solution = aqueousSolution;
            this.solution.addAqueousSolutionChangeListener(this.solutionChangeListener);
            this.fireSolutionChanged();
        }
    }

    public AqueousSolution getSolution() {
        return this.solution;
    }

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public void setLocation(double d, double d2) {
        if (d != this.location.getX() || d2 != this.location.getY()) {
            this.location.setLocation(d, d2);
            this.fireLocationChanged();
        }
    }

    public Point2D getLocationReference() {
        return this.location;
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.fireVisibilityChanged();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void addSolutionRepresentationChangeListener(SolutionRepresentationChangeListener solutionRepresentationChangeListener) {
        this.listeners.add(SolutionRepresentationChangeListener.class, solutionRepresentationChangeListener);
    }

    private void fireSolutionChanged() {
        for (SolutionRepresentationChangeListener solutionRepresentationChangeListener : (SolutionRepresentationChangeListener[])this.listeners.getListeners(SolutionRepresentationChangeListener.class)) {
            solutionRepresentationChangeListener.solutionChanged();
        }
    }

    private void fireConcentrationChanged() {
        for (SolutionRepresentationChangeListener solutionRepresentationChangeListener : (SolutionRepresentationChangeListener[])this.listeners.getListeners(SolutionRepresentationChangeListener.class)) {
            solutionRepresentationChangeListener.concentrationChanged();
        }
    }

    private void fireStrengthChanged() {
        for (SolutionRepresentationChangeListener solutionRepresentationChangeListener : (SolutionRepresentationChangeListener[])this.listeners.getListeners(SolutionRepresentationChangeListener.class)) {
            solutionRepresentationChangeListener.strengthChanged();
        }
    }

    private void fireLocationChanged() {
        for (SolutionRepresentationChangeListener solutionRepresentationChangeListener : (SolutionRepresentationChangeListener[])this.listeners.getListeners(SolutionRepresentationChangeListener.class)) {
            solutionRepresentationChangeListener.locationChanged();
        }
    }

    private void fireVisibilityChanged() {
        for (SolutionRepresentationChangeListener solutionRepresentationChangeListener : (SolutionRepresentationChangeListener[])this.listeners.getListeners(SolutionRepresentationChangeListener.class)) {
            solutionRepresentationChangeListener.visibilityChanged();
        }
    }

    public static class SolutionRepresentationChangeAdapter
    implements SolutionRepresentationChangeListener {
        public void solutionChanged() {
        }

        public void concentrationChanged() {
        }

        public void strengthChanged() {
        }

        public void locationChanged() {
        }

        public void visibilityChanged() {
        }
    }

    public static interface SolutionRepresentationChangeListener
    extends EventListener {
        public void solutionChanged();

        public void concentrationChanged();

        public void strengthChanged();

        public void locationChanged();

        public void visibilityChanged();
    }
}

