/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSColors;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Beaker;
import edu.colorado.phet.acidbasesolutions.model.PHColorFactory;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class PHPaper
extends SolutionRepresentation {
    private final PDimension size;
    private final Beaker beaker;
    private Color dippedColor;
    private double dippedHeight;
    private final EventListenerList listeners;

    public PHPaper(AqueousSolution aqueousSolution, Point2D point2D, boolean bl, PDimension pDimension, Beaker beaker) {
        super(aqueousSolution, point2D, bl);
        this.size = new PDimension(pDimension);
        this.beaker = beaker;
        this.listeners = new EventListenerList();
        this.dippedHeight = this.computeDippedHeight();
        this.dippedColor = this.createColor(aqueousSolution.getPH());
        this.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void solutionChanged() {
                PHPaper.this.setDippedHeight(PHPaper.this.computeDippedHeight());
                PHPaper.this.updateDippedColor();
            }

            public void concentrationChanged() {
                PHPaper.this.setDippedHeight(PHPaper.this.computeDippedHeight());
                PHPaper.this.updateDippedColor();
            }

            public void strengthChanged() {
                PHPaper.this.setDippedHeight(PHPaper.this.computeDippedHeight());
                PHPaper.this.updateDippedColor();
            }

            public void locationChanged() {
                PHPaper.this.setDippedHeight(Math.max(PHPaper.this.dippedHeight, PHPaper.this.computeDippedHeight()));
            }
        });
    }

    public double getWidth() {
        return this.size.getWidth();
    }

    public double getHeight() {
        return this.size.getHeight();
    }

    public void setLocation(double d, double d2) {
        super.setLocation(this.constrainX(d), this.constrainY(d2));
    }

    private double constrainX(double d) {
        double d2 = this.beaker.getLocationReference().getX() - this.beaker.getWidth() / 2.0 + this.getWidth() / 2.0 + 20.0;
        double d3 = this.beaker.getLocationReference().getX() + this.beaker.getWidth() / 2.0 - this.getWidth() / 2.0 - 20.0;
        double d4 = d;
        if (d4 < d2) {
            d4 = d2;
        } else if (d4 > d3) {
            d4 = d3;
        }
        return d4;
    }

    private double constrainY(double d) {
        double d2 = this.beaker.getLocationReference().getY() - this.beaker.getHeight() - this.getHeight() - 20.0;
        double d3 = this.beaker.getLocationReference().getY() - this.getHeight() - 20.0;
        double d4 = d;
        if (d4 < d2) {
            d4 = d2;
        } else if (d4 > d3) {
            d4 = d3;
        }
        return d4;
    }

    public Color getPaperColor() {
        return ABSColors.PH_PAPER;
    }

    private void updateDippedColor() {
        this.setDippedColor(this.createColor(this.getSolution().getPH()));
    }

    private void setDippedColor(Color color) {
        if (!color.equals(this.dippedColor)) {
            this.dippedColor = color;
            this.fireDippedColorChanged();
        }
    }

    public Color getDippedColor() {
        return this.dippedColor;
    }

    public Color createColor(double d) {
        return PHColorFactory.createColor(d);
    }

    private void setDippedHeight(double d) {
        if (d != this.dippedHeight) {
            this.dippedHeight = d;
            this.fireDippedHeightChanged();
        }
    }

    public double getDippedHeight() {
        return this.dippedHeight;
    }

    private double computeDippedHeight() {
        double d = this.beaker.getY();
        double d2 = this.getY();
        double d3 = this.beaker.getHeight();
        double d4 = this.getHeight();
        double d5 = -Math.abs(d - d2) + d3 + d4;
        if (d5 < 0.0) {
            d5 = 0.0;
        } else if (d5 > d4) {
            d5 = d4;
        }
        if (d5 > 0.0) {
            d5 += 15.0;
        }
        if (d5 > this.size.getHeight()) {
            d5 = this.size.getHeight();
        }
        return d5;
    }

    public boolean isInSolution() {
        double d = this.beaker.getY();
        double d2 = this.getY();
        double d3 = this.beaker.getHeight();
        double d4 = this.getHeight();
        return -Math.abs(d - d2) + d3 + d4 > 0.0;
    }

    public void addPHPaperChangeListener(PHPaperChangeListener pHPaperChangeListener) {
        this.listeners.add(PHPaperChangeListener.class, pHPaperChangeListener);
    }

    private void fireDippedColorChanged() {
        for (PHPaperChangeListener pHPaperChangeListener : (PHPaperChangeListener[])this.listeners.getListeners(PHPaperChangeListener.class)) {
            pHPaperChangeListener.dippedColorChanged();
        }
    }

    private void fireDippedHeightChanged() {
        for (PHPaperChangeListener pHPaperChangeListener : (PHPaperChangeListener[])this.listeners.getListeners(PHPaperChangeListener.class)) {
            pHPaperChangeListener.dippedHeightChanged();
        }
    }

    public static interface PHPaperChangeListener
    extends EventListener {
        public void dippedColorChanged();

        public void dippedHeightChanged();
    }
}

