/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Beaker;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public class PHMeter
extends SolutionRepresentation {
    private final PDimension shaftSize;
    private final PDimension tipSize;
    private final Beaker beaker;

    public PHMeter(AqueousSolution aqueousSolution, Point2D point2D, boolean bl, PDimension pDimension, PDimension pDimension2, Beaker beaker) {
        super(aqueousSolution, point2D, bl);
        this.shaftSize = pDimension;
        this.tipSize = pDimension2;
        this.beaker = beaker;
    }

    public void setLocation(double d, double d2) {
        super.setLocation(d, this.constrainY(d2));
    }

    private double constrainY(double d) {
        double d2 = this.beaker.getLocationReference().getY() - this.beaker.getHeight() - 20.0;
        double d3 = this.beaker.getLocationReference().getY() - this.beaker.getHeight() + this.getProbeHeight() - 20.0;
        double d4 = d;
        if (d4 < d2) {
            d4 = d2;
        } else if (d4 > d3) {
            d4 = d3;
        }
        return d4;
    }

    public PDimension getShaftSizeReference() {
        return this.shaftSize;
    }

    public PDimension getTipSizeRefernence() {
        return this.tipSize;
    }

    public double getProbeHeight() {
        return this.shaftSize.getHeight() + this.tipSize.getHeight();
    }

    public Double getValue() {
        Double d = null;
        if (this.isInSolution()) {
            d = new Double(this.getSolution().getPH());
        }
        return d;
    }

    public boolean isInSolution() {
        return this.beaker.inSolution(this.getLocationReference());
    }
}

