/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSColors;
import edu.colorado.phet.acidbasesolutions.constants.ABSImages;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import java.awt.Color;
import java.awt.Image;

public abstract class Molecule {
    private final String name;
    private final String symbol;
    private final Image image;
    private final Color color;

    public Molecule(String string, String string2, Image image, Color color) {
        this.name = string;
        this.symbol = string2;
        this.image = image;
        this.color = color;
    }

    public Molecule(String string, Image image, Color color) {
        this(string, string, image, color);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Image getImage() {
        return this.image;
    }

    public Color getColor() {
        return this.color;
    }

    public static class GenericAcidMolecule
    extends Molecule {
        public GenericAcidMolecule() {
            super("H<i>A</i>", ABSImages.HA_MOLECULE, ABSColors.HA);
        }
    }

    public static class GenericAcidProductMolecule
    extends Molecule {
        public GenericAcidProductMolecule() {
            super("<i>A</i><sup>-</sup>", ABSImages.A_MINUS_MOLECULE, ABSColors.A_MINUS);
        }
    }

    public static class GenericStrongBaseMolecule
    extends Molecule {
        public GenericStrongBaseMolecule() {
            super("<i>M</i>OH", ABSImages.MOH_MOLECULE, ABSColors.MOH);
        }
    }

    public static class GenericStrongBaseProductMolecule
    extends Molecule {
        public GenericStrongBaseProductMolecule() {
            super("<i>M</i><sup>+</sup>", ABSImages.M_PLUS_MOLECULE, ABSColors.M_PLUS);
        }
    }

    public static class GenericWeakBaseMolecule
    extends Molecule {
        public GenericWeakBaseMolecule() {
            super("<i>B</i>", ABSImages.B_MOLECULE, ABSColors.B);
        }
    }

    public static class GenericWeakBaseProductMolecule
    extends Molecule {
        public GenericWeakBaseProductMolecule() {
            super("<i>B</i>H<sup>+</sup>", ABSImages.BH_PLUS_MOLECULE, ABSColors.BH_PLUS);
        }
    }

    public static class H3OMolecule
    extends Molecule {
        public H3OMolecule() {
            super("H<sub>3</sub>O<sup>+</sup>", ABSImages.H3O_PLUS_MOLECULE, ABSColors.H3O_PLUS);
        }
    }

    public static class OHMolecule
    extends Molecule {
        public OHMolecule() {
            super("OH<sup>-</sup>", ABSImages.OH_MINUS_MOLECULE, ABSColors.OH_MINUS);
        }
    }

    public static class WaterMolecule
    extends Molecule {
        public WaterMolecule() {
            super(ABSStrings.WATER, "H<sub>2</sub>O", ABSImages.H2O_MOLECULE, ABSColors.H2O);
        }
    }
}

