/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import java.awt.geom.Point2D;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class MagnifyingGlass
extends SolutionRepresentation {
    private final double diameter;
    private boolean waterVisibile;
    private final EventListenerList listeners;

    public MagnifyingGlass(AqueousSolution aqueousSolution, Point2D point2D, boolean bl, double d, boolean bl2) {
        super(aqueousSolution, point2D, bl);
        this.diameter = d;
        this.waterVisibile = bl2;
        this.listeners = new EventListenerList();
    }

    public double getDiameter() {
        return this.diameter;
    }

    public void setWaterVisible(boolean bl) {
        if (bl != this.waterVisibile) {
            this.waterVisibile = bl;
            this.fireWaterVisibleChanged();
        }
    }

    public boolean isWaterVisible() {
        return this.waterVisibile;
    }

    public void addMagnifyingGlassListener(MagnifyingGlassChangeListener magnifyingGlassChangeListener) {
        this.listeners.add(MagnifyingGlassChangeListener.class, magnifyingGlassChangeListener);
    }

    private void fireWaterVisibleChanged() {
        for (MagnifyingGlassChangeListener magnifyingGlassChangeListener : (MagnifyingGlassChangeListener[])this.listeners.getListeners(MagnifyingGlassChangeListener.class)) {
            magnifyingGlassChangeListener.waterVisibleChanged();
        }
    }

    public static interface MagnifyingGlassChangeListener
    extends EventListener {
        public void waterVisibleChanged();
    }
}

