/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Beaker;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.IConductivityTester;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;
import javax.swing.event.EventListenerList;

public class ConductivityTester
extends SolutionRepresentation
implements IConductivityTester {
    private final Beaker beaker;
    private final PDimension probeSize;
    private Point2D positiveProbeLocation;
    private Point2D negativeProbeLocation;
    private final EventListenerList listeners;
    private double brightness;

    public ConductivityTester(AqueousSolution aqueousSolution, Point2D point2D, boolean bl, PDimension pDimension, Point2D point2D2, Point2D point2D3, Beaker beaker) {
        super(aqueousSolution, point2D, bl);
        this.probeSize = new PDimension(pDimension);
        this.positiveProbeLocation = new Point2D.Double(point2D2.getX(), point2D2.getY());
        this.negativeProbeLocation = new Point2D.Double(point2D3.getX(), point2D3.getY());
        this.beaker = beaker;
        this.listeners = new EventListenerList();
        this.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void solutionChanged() {
                ConductivityTester.this.updateBrightness();
            }

            public void concentrationChanged() {
                ConductivityTester.this.updateBrightness();
            }

            public void strengthChanged() {
                ConductivityTester.this.updateBrightness();
            }
        });
        this.updateBrightness();
    }

    public double getBrightness() {
        return this.brightness;
    }

    private void updateBrightness() {
        this.brightness = this.isCircuitCompleted() ? this.pHToBrightness(this.getSolution().getPH()) : 0.0;
        this.fireBrightnessChanged();
    }

    private double pHToBrightness(double d) {
        double d2 = 0.0;
        d2 = d < 7.0 ? 0.05 + 0.95 * ((7.0 - d) / 7.0) : 0.05 + 0.95 * ((d - 7.0) / 7.0);
        return d2;
    }

    public PDimension getProbeSizeReference() {
        return this.probeSize;
    }

    public void setPositiveProbeLocation(Point2D point2D) {
        this.setPositiveProbeLocation(point2D.getX(), point2D.getY());
    }

    public void setPositiveProbeLocation(double d, double d2) {
        if (d != this.positiveProbeLocation.getX() || d2 != this.positiveProbeLocation.getY()) {
            this.positiveProbeLocation.setLocation(d, this.constrainY(d2));
            this.firePositiveProbeLocationChanged();
            this.updateBrightness();
        }
    }

    public Point2D getPositiveProbeLocationReference() {
        return this.positiveProbeLocation;
    }

    public void setNegativeProbeLocation(Point2D point2D) {
        this.setNegativeProbeLocation(point2D.getX(), point2D.getY());
    }

    public void setNegativeProbeLocation(double d, double d2) {
        if (d != this.negativeProbeLocation.getX() || d2 != this.negativeProbeLocation.getY()) {
            this.negativeProbeLocation.setLocation(d, this.constrainY(d2));
            this.fireNegativeProbeLocationChanged();
            this.updateBrightness();
        }
    }

    public Point2D getNegativeProbeLocationReference() {
        return this.negativeProbeLocation;
    }

    public boolean isNegativeProbeInSolution() {
        return this.beaker.inSolution(this.negativeProbeLocation);
    }

    public boolean isPositiveProbeInSolution() {
        return this.beaker.inSolution(this.positiveProbeLocation);
    }

    public boolean isCircuitCompleted() {
        return this.isPositiveProbeInSolution() && this.isNegativeProbeInSolution();
    }

    private double constrainY(double d) {
        double d2 = this.beaker.getLocationReference().getY() - this.beaker.getHeight() - 50.0;
        double d3 = this.beaker.getLocationReference().getY() - 20.0;
        double d4 = d;
        if (d4 < d2) {
            d4 = d2;
        } else if (d4 > d3) {
            d4 = d3;
        }
        return d4;
    }

    public void addConductivityTesterChangeListener(IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener) {
        this.listeners.add(IConductivityTester.ConductivityTesterChangeListener.class, conductivityTesterChangeListener);
    }

    private void fireBrightnessChanged() {
        for (IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener : (IConductivityTester.ConductivityTesterChangeListener[])this.listeners.getListeners(IConductivityTester.ConductivityTesterChangeListener.class)) {
            conductivityTesterChangeListener.brightnessChanged();
        }
    }

    private void firePositiveProbeLocationChanged() {
        for (IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener : (IConductivityTester.ConductivityTesterChangeListener[])this.listeners.getListeners(IConductivityTester.ConductivityTesterChangeListener.class)) {
            conductivityTesterChangeListener.positiveProbeLocationChanged();
        }
    }

    private void fireNegativeProbeLocationChanged() {
        for (IConductivityTester.ConductivityTesterChangeListener conductivityTesterChangeListener : (IConductivityTester.ConductivityTesterChangeListener[])this.listeners.getListeners(IConductivityTester.ConductivityTesterChangeListener.class)) {
            conductivityTesterChangeListener.negativeProbeLocationChanged();
        }
    }
}

