/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSColors;
import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.model.Molecule;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import java.awt.Color;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class AqueousSolution {
    private static final Molecule.WaterMolecule WATER_MOLECULE = new Molecule.WaterMolecule();
    private static final Molecule.H3OMolecule H3O_MOLECULE = new Molecule.H3OMolecule();
    private static final Molecule.OHMolecule OH_MOLECULE = new Molecule.OHMolecule();
    private final Molecule solute;
    private final Molecule product;
    private double strength;
    private double concentration;
    private final EventListenerList listeners;

    public AqueousSolution(Molecule molecule, Molecule molecule2, double d, double d2) {
        this.solute = molecule;
        this.product = molecule2;
        this.strength = d;
        this.concentration = d2;
        this.listeners = new EventListenerList();
    }

    public Color getColor() {
        return ABSColors.AQUEOUS_SOLUTION;
    }

    public Molecule.WaterMolecule getWaterMolecule() {
        return WATER_MOLECULE;
    }

    public Molecule.H3OMolecule getH3OMolecule() {
        return H3O_MOLECULE;
    }

    public Molecule.OHMolecule getOHMolecule() {
        return OH_MOLECULE;
    }

    public Molecule getSolute() {
        return this.solute;
    }

    public Molecule getProduct() {
        return this.product;
    }

    protected void setStrength(double d) {
        if (!this.isValidStrength(d)) {
            throw new IllegalArgumentException("invalid strength: " + d);
        }
        if (d != this.strength) {
            this.strength = d;
            this.fireStrengthChanged();
        }
    }

    public double getStrength() {
        return this.strength;
    }

    protected abstract boolean isValidStrength(double var1);

    protected void setConcentration(double d) {
        if (!this.isValidConcentration(d)) {
            throw new IllegalArgumentException("invalid concentration: " + d);
        }
        if (d != this.concentration) {
            this.concentration = d;
            this.fireConcentrationChanged();
        }
    }

    public double getConcentration() {
        return this.concentration;
    }

    protected boolean isValidConcentration(double d) {
        return ABSConstants.CONCENTRATION_RANGE.contains(d);
    }

    public double getPH() {
        return -MathUtil.log10(this.getH3OConcentration());
    }

    public abstract double getSoluteConcentration();

    public abstract double getProductConcentration();

    public abstract double getH3OConcentration();

    public abstract double getOHConcentration();

    public abstract double getH2OConcentration();

    protected static double getWaterConcentration() {
        return 55.6;
    }

    protected static double getWaterEquilibriumConstant() {
        return 1.0E-14;
    }

    public void addAqueousSolutionChangeListener(AqueousSolutionChangeListener aqueousSolutionChangeListener) {
        this.listeners.add(AqueousSolutionChangeListener.class, aqueousSolutionChangeListener);
    }

    public void removeAqueousSolutionChangeListener(AqueousSolutionChangeListener aqueousSolutionChangeListener) {
        this.listeners.remove(AqueousSolutionChangeListener.class, aqueousSolutionChangeListener);
    }

    private void fireStrengthChanged() {
        for (AqueousSolutionChangeListener aqueousSolutionChangeListener : (AqueousSolutionChangeListener[])this.listeners.getListeners(AqueousSolutionChangeListener.class)) {
            aqueousSolutionChangeListener.strengthChanged();
        }
    }

    private void fireConcentrationChanged() {
        for (AqueousSolutionChangeListener aqueousSolutionChangeListener : (AqueousSolutionChangeListener[])this.listeners.getListeners(AqueousSolutionChangeListener.class)) {
            aqueousSolutionChangeListener.concentrationChanged();
        }
    }

    public static interface AqueousSolutionChangeListener
    extends EventListener {
        public void strengthChanged();

        public void concentrationChanged();
    }

    public static interface ICustomSolution {
    }
}

