/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.model;

import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Beaker;
import edu.colorado.phet.acidbasesolutions.model.ConcentrationGraph;
import edu.colorado.phet.acidbasesolutions.model.ConductivityTester;
import edu.colorado.phet.acidbasesolutions.model.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.model.PHMeter;
import edu.colorado.phet.acidbasesolutions.model.PHPaper;
import edu.colorado.phet.acidbasesolutions.model.ReactionEquation;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class ABSModel {
    private final SolutionFactory defaultSolutionFactory;
    private AqueousSolution solution;
    private final Beaker beaker;
    private final PHMeter pHMeter;
    private final MagnifyingGlass magnifyingGlass;
    private final ConcentrationGraph concentrationGraph;
    private final ReactionEquation reactionEquation;
    private final PHPaper pHPaper;
    private final ConductivityTester conductivityTester;
    private EventListenerList listeners;

    public ABSModel(SolutionFactory solutionFactory) {
        this.defaultSolutionFactory = solutionFactory;
        this.solution = solutionFactory.createSolution();
        this.beaker = new Beaker(this.solution, ABSConstants.BEAKER_LOCATION, true, ABSConstants.BEAKER_SIZE);
        this.pHMeter = new PHMeter(this.solution, ABSConstants.PH_METER_LOCATION, true, ABSConstants.PH_METER_SHAFT_SIZE, ABSConstants.PH_METER_TIP_SIZE, this.beaker);
        this.magnifyingGlass = new MagnifyingGlass(this.solution, ABSConstants.MAGNIFYING_GLASS_LOCATION, true, 500.0, false);
        this.concentrationGraph = new ConcentrationGraph(this.solution, ABSConstants.CONCENTRATION_GRAPH_LOCATION, false, ABSConstants.CONCENTRATION_GRAPH_SIZE);
        this.reactionEquation = new ReactionEquation(this.solution, ABSConstants.REACTION_EQUATION_LOCATION, true);
        this.pHPaper = new PHPaper(this.solution, ABSConstants.PH_PAPER_LOCATION, false, ABSConstants.PH_PAPER_SIZE, this.beaker);
        this.conductivityTester = new ConductivityTester(this.solution, ABSConstants.CONDUCTIVITY_TESTER_LOCATION, false, ABSConstants.CONDUCTIVITY_TESTER_PROBE_SIZE, ABSConstants.CONDUCTIVITY_TESTER_POSITIVE_PROBE_LOCATION, ABSConstants.CONDUCTIVITY_TESTER_NEGATIVE_PROBE_LOCATION, this.beaker);
        this.listeners = new EventListenerList();
        this.reset();
    }

    public void reset() {
        this.setSolution(this.defaultSolutionFactory.createSolution());
        this.pHMeter.setLocation(ABSConstants.PH_METER_LOCATION);
        this.pHMeter.setVisible(true);
        this.pHPaper.setLocation(ABSConstants.PH_PAPER_LOCATION);
        this.pHPaper.setVisible(false);
        this.conductivityTester.setLocation(ABSConstants.CONDUCTIVITY_TESTER_LOCATION);
        this.conductivityTester.setPositiveProbeLocation(ABSConstants.CONDUCTIVITY_TESTER_POSITIVE_PROBE_LOCATION);
        this.conductivityTester.setNegativeProbeLocation(ABSConstants.CONDUCTIVITY_TESTER_NEGATIVE_PROBE_LOCATION);
        this.conductivityTester.setVisible(false);
        this.magnifyingGlass.setVisible(true);
        this.magnifyingGlass.setWaterVisible(false);
        this.concentrationGraph.setVisible(false);
    }

    public Beaker getBeaker() {
        return this.beaker;
    }

    public MagnifyingGlass getMagnifyingGlass() {
        return this.magnifyingGlass;
    }

    public PHMeter getPHMeter() {
        return this.pHMeter;
    }

    public ConcentrationGraph getConcentrationGraph() {
        return this.concentrationGraph;
    }

    public ReactionEquation getReactionEquation() {
        return this.reactionEquation;
    }

    public PHPaper getPHPaper() {
        return this.pHPaper;
    }

    public ConductivityTester getConductivityTester() {
        return this.conductivityTester;
    }

    public void setSolution(AqueousSolution aqueousSolution) {
        if (aqueousSolution != this.solution) {
            this.solution = aqueousSolution;
            this.beaker.setSolution(aqueousSolution);
            this.pHMeter.setSolution(aqueousSolution);
            this.magnifyingGlass.setSolution(aqueousSolution);
            this.concentrationGraph.setSolution(aqueousSolution);
            this.reactionEquation.setSolution(aqueousSolution);
            this.pHPaper.setSolution(aqueousSolution);
            this.conductivityTester.setSolution(aqueousSolution);
            this.fireSolutionChanged();
        }
    }

    public AqueousSolution getSolution() {
        return this.solution;
    }

    public void addModelChangeListener(ModelChangeListener modelChangeListener) {
        this.listeners.add(ModelChangeListener.class, modelChangeListener);
    }

    private void fireSolutionChanged() {
        for (ModelChangeListener modelChangeListener : (ModelChangeListener[])this.listeners.getListeners(ModelChangeListener.class)) {
            modelChangeListener.solutionChanged();
        }
    }

    public static interface ModelChangeListener
    extends EventListener {
        public void solutionChanged();
    }

    public static interface SolutionFactory {
        public AqueousSolution createSolution();
    }
}

