/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.controls;

import edu.colorado.phet.acidbasesolutions.constants.ABSImages;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.model.ABSModel;
import edu.colorado.phet.acidbasesolutions.model.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.model.Molecule;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.acidbasesolutions.view.graph.ConcentrationGraphNode;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingIcon;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJCheckBox;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJRadioButton;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.controls.HTMLRadioButton;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ViewControls
extends PhetTitledPanel {
    private final ABSModel model;
    private final JRadioButton magnifyingGlassRadioButton;
    private final JRadioButton liquidRadioButton;
    private final HTMLRadioButton concentrationGraphRadioButton;
    private final JLabel magnifyingGlassIcon;
    private final JLabel concentrationGraphIcon;
    private final JLabel liquidIcon;
    private final JLabel showWaterIcon;
    private final JCheckBox showWaterCheckBox;
    private boolean controlsEnabled;

    public ViewControls(final ABSModel aBSModel) {
        super(ABSStrings.VIEWS);
        this.model = aBSModel;
        aBSModel.getMagnifyingGlass().addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                if (ViewControls.this.controlsEnabled) {
                    ViewControls.this.magnifyingGlassRadioButton.setSelected(aBSModel.getMagnifyingGlass().isVisible());
                    ViewControls.this.showWaterCheckBox.setEnabled(aBSModel.getMagnifyingGlass().isVisible());
                    ViewControls.this.showWaterIcon.setEnabled(aBSModel.getMagnifyingGlass().isVisible());
                }
            }
        });
        aBSModel.getConcentrationGraph().addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                if (ViewControls.this.controlsEnabled) {
                    ViewControls.this.concentrationGraphRadioButton.setSelected(aBSModel.getConcentrationGraph().isVisible());
                    ViewControls.this.showWaterCheckBox.setEnabled(aBSModel.getMagnifyingGlass().isVisible());
                    ViewControls.this.showWaterIcon.setEnabled(aBSModel.getMagnifyingGlass().isVisible());
                }
            }
        });
        aBSModel.getMagnifyingGlass().addMagnifyingGlassListener(new MagnifyingGlass.MagnifyingGlassChangeListener(){

            public void waterVisibleChanged() {
                ViewControls.this.showWaterCheckBox.setSelected(aBSModel.getMagnifyingGlass().isWaterVisible());
                ViewControls.this.showWaterIcon.setEnabled(aBSModel.getMagnifyingGlass().isVisible());
            }
        });
        aBSModel.getConductivityTester().addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                ViewControls.this.setControlsEnabled(!aBSModel.getConductivityTester().isVisible());
            }
        });
        Object object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewControls.this.updateModel();
            }
        };
        this.magnifyingGlassRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.magnifyingGlassRadioButton, ABSStrings.MOLECULES);
        this.magnifyingGlassRadioButton.addActionListener((ActionListener)object);
        this.concentrationGraphRadioButton = new HTMLRadioButton(ABSSimSharing.UserComponents.concentrationGraphRadioButton, ABSStrings.EQUILIBRIUM_CONCENTRATION);
        this.concentrationGraphRadioButton.addActionListener((ActionListener)object);
        this.liquidRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.liquidRadioButton, ABSStrings.LIQUID);
        this.liquidRadioButton.addActionListener((ActionListener)object);
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.magnifyingGlassRadioButton);
        ((ButtonGroup)serializable).add(this.concentrationGraphRadioButton);
        ((ButtonGroup)serializable).add(this.liquidRadioButton);
        this.showWaterCheckBox = new SimSharingJCheckBox(ABSSimSharing.UserComponents.showSolventCheckBox, ABSStrings.SHOW_WATER);
        this.showWaterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                aBSModel.getMagnifyingGlass().setWaterVisible(ViewControls.this.showWaterCheckBox.isSelected());
            }
        });
        this.magnifyingGlassIcon = new SimSharingIcon(ABSSimSharing.UserComponents.magnifyingGlassIcon, ABSImages.MAGNIFYING_GLASS_ICON, new VoidFunction0(){

            public void apply() {
                if (ViewControls.this.controlsEnabled) {
                    ViewControls.this.magnifyingGlassRadioButton.setSelected(true);
                    ViewControls.this.updateModel();
                }
            }
        });
        object = ABSImages.createIcon(new Molecule.WaterMolecule().getImage(), 0.75);
        this.showWaterIcon = new SimSharingIcon(ABSSimSharing.UserComponents.waterIcon, (Icon)object, new VoidFunction0(){

            public void apply() {
                if (ViewControls.this.controlsEnabled && ViewControls.this.showWaterCheckBox.isEnabled()) {
                    ViewControls.this.showWaterCheckBox.setSelected(!ViewControls.this.showWaterCheckBox.isSelected());
                    aBSModel.getMagnifyingGlass().setWaterVisible(ViewControls.this.showWaterCheckBox.isSelected());
                }
            }
        });
        this.concentrationGraphIcon = new SimSharingIcon(ABSSimSharing.UserComponents.concentrationGraphIcon, ConcentrationGraphNode.createIcon(), new VoidFunction0(){

            public void apply() {
                if (ViewControls.this.controlsEnabled) {
                    ViewControls.this.concentrationGraphRadioButton.setSelected(true);
                    ViewControls.this.updateModel();
                }
            }
        });
        this.liquidIcon = new SimSharingIcon(ABSSimSharing.UserComponents.liquidIcon, ABSImages.BEAKER_ICON, new VoidFunction0(){

            public void apply() {
                if (ViewControls.this.controlsEnabled) {
                    ViewControls.this.liquidRadioButton.setSelected(true);
                    ViewControls.this.updateModel();
                }
            }
        });
        serializable = new HorizontalLayoutPanel();
        ((HorizontalLayoutPanel)serializable).setInsets(new Insets(0, 5, 0, 0));
        ((HorizontalLayoutPanel)serializable).add(this.magnifyingGlassRadioButton);
        ((HorizontalLayoutPanel)serializable).add(this.magnifyingGlassIcon);
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        horizontalLayoutPanel.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel.add(this.showWaterCheckBox);
        horizontalLayoutPanel.add(this.showWaterIcon);
        HorizontalLayoutPanel horizontalLayoutPanel2 = new HorizontalLayoutPanel();
        horizontalLayoutPanel2.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel2.add(this.concentrationGraphRadioButton);
        horizontalLayoutPanel2.add(this.concentrationGraphIcon);
        HorizontalLayoutPanel horizontalLayoutPanel3 = new HorizontalLayoutPanel();
        horizontalLayoutPanel3.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel3.add(this.liquidRadioButton);
        horizontalLayoutPanel3.add(this.liquidIcon);
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.addComponent((Component)serializable, 0, 0, 2, 1);
        easyGridBagLayout.setMinimumWidth(0, 22);
        easyGridBagLayout.addComponent(horizontalLayoutPanel, 1, 1, 1, 1);
        easyGridBagLayout.addComponent(horizontalLayoutPanel2, 2, 0, 2, 1);
        easyGridBagLayout.addComponent(horizontalLayoutPanel3, 3, 0, 2, 1);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this.magnifyingGlassRadioButton.setSelected(aBSModel.getMagnifyingGlass().isVisible());
        this.showWaterCheckBox.setSelected(aBSModel.getMagnifyingGlass().isWaterVisible());
        this.concentrationGraphRadioButton.setSelected(aBSModel.getConcentrationGraph().isVisible());
        this.controlsEnabled = true;
        this.setControlsEnabled(!aBSModel.getConductivityTester().isVisible());
    }

    private void updateModel() {
        this.model.getMagnifyingGlass().setVisible(this.magnifyingGlassRadioButton.isSelected());
        this.model.getConcentrationGraph().setVisible(this.concentrationGraphRadioButton.isSelected());
    }

    private void setControlsEnabled(boolean bl) {
        if (bl != this.controlsEnabled) {
            this.controlsEnabled = bl;
            this.magnifyingGlassRadioButton.setEnabled(bl);
            this.magnifyingGlassIcon.setEnabled(bl);
            this.showWaterCheckBox.setEnabled(bl && this.magnifyingGlassRadioButton.isSelected());
            this.showWaterIcon.setEnabled(bl && this.magnifyingGlassRadioButton.isSelected());
            this.concentrationGraphRadioButton.setEnabled(bl);
            this.concentrationGraphIcon.setEnabled(bl);
            this.liquidRadioButton.setEnabled(bl);
            this.liquidIcon.setEnabled(bl);
            if (bl) {
                this.model.getMagnifyingGlass().setVisible(this.magnifyingGlassRadioButton.isSelected());
                this.model.getConcentrationGraph().setVisible(this.concentrationGraphRadioButton.isSelected());
            } else {
                this.model.getMagnifyingGlass().setVisible(false);
                this.model.getConcentrationGraph().setVisible(false);
            }
        }
    }
}

