/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.controls;

import edu.colorado.phet.acidbasesolutions.constants.ABSImages;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.model.ABSModel;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingIcon;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJRadioButton;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TestControls
extends PhetTitledPanel {
    private final ABSModel model;
    private final JRadioButton pHMeterRadioButton;
    private final JRadioButton pHPaperRadioButton;
    private final JRadioButton conductivityTesterRadioButton;
    private boolean isSyncingWithModel;

    public TestControls(final ABSModel aBSModel) {
        super(ABSStrings.TESTS);
        this.model = aBSModel;
        this.isSyncingWithModel = false;
        aBSModel.getPHMeter().addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                TestControls.this.pHMeterRadioButton.setSelected(aBSModel.getPHMeter().isVisible());
            }
        });
        aBSModel.getPHPaper().addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                TestControls.this.pHPaperRadioButton.setSelected(aBSModel.getPHPaper().isVisible());
            }
        });
        aBSModel.getConductivityTester().addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                TestControls.this.conductivityTesterRadioButton.setSelected(aBSModel.getConductivityTester().isVisible());
            }
        });
        Object object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestControls.this.updateModel();
            }
        };
        this.pHMeterRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.phMeterRadioButton, ABSStrings.PH_METER);
        this.pHMeterRadioButton.addActionListener((ActionListener)object);
        this.pHPaperRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.phPaperRadioButton, ABSStrings.PH_PAPER);
        this.pHPaperRadioButton.addActionListener((ActionListener)object);
        this.conductivityTesterRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.conductivityTesterRadioButton, ABSStrings.CONDUCTIVITY);
        this.conductivityTesterRadioButton.addActionListener((ActionListener)object);
        Serializable serializable = new ButtonGroup();
        serializable.add(this.pHMeterRadioButton);
        serializable.add(this.pHPaperRadioButton);
        serializable.add(this.conductivityTesterRadioButton);
        object = new SimSharingIcon(ABSSimSharing.UserComponents.phMeterIcon, ABSImages.PH_METER_ICON, new VoidFunction0(){

            public void apply() {
                TestControls.this.pHMeterRadioButton.setSelected(true);
                TestControls.this.updateModel();
            }
        });
        serializable = new SimSharingIcon(ABSSimSharing.UserComponents.phPaperIcon, ABSImages.PH_PAPER_ICON, new VoidFunction0(){

            public void apply() {
                TestControls.this.pHPaperRadioButton.setSelected(true);
                TestControls.this.updateModel();
            }
        });
        SimSharingIcon simSharingIcon = new SimSharingIcon(ABSSimSharing.UserComponents.conductivityTesterIcon, ABSImages.LIGHT_BULB_ICON, new VoidFunction0(){

            public void apply() {
                TestControls.this.conductivityTesterRadioButton.setSelected(true);
                TestControls.this.updateModel();
            }
        });
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        horizontalLayoutPanel.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel.add(this.pHMeterRadioButton);
        horizontalLayoutPanel.add((Component)object);
        HorizontalLayoutPanel horizontalLayoutPanel2 = new HorizontalLayoutPanel();
        horizontalLayoutPanel2.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel2.add(this.pHPaperRadioButton);
        horizontalLayoutPanel2.add((Component)serializable);
        HorizontalLayoutPanel horizontalLayoutPanel3 = new HorizontalLayoutPanel();
        horizontalLayoutPanel3.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel3.add(this.conductivityTesterRadioButton);
        horizontalLayoutPanel3.add(simSharingIcon);
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(horizontalLayoutPanel, n++, n2);
        easyGridBagLayout.addComponent(horizontalLayoutPanel2, n++, n2);
        easyGridBagLayout.addComponent(horizontalLayoutPanel3, n++, n2);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this.pHMeterRadioButton.setSelected(aBSModel.getPHMeter().isVisible());
        this.pHPaperRadioButton.setSelected(aBSModel.getPHPaper().isVisible());
        this.conductivityTesterRadioButton.setSelected(aBSModel.getConductivityTester().isVisible());
    }

    private void updateModel() {
        if (!this.isSyncingWithModel) {
            this.model.getPHMeter().setVisible(this.pHMeterRadioButton.isSelected());
            this.model.getPHPaper().setVisible(this.pHPaperRadioButton.isSelected());
            this.model.getConductivityTester().setVisible(this.conductivityTesterRadioButton.isSelected());
        }
    }
}

