/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.controls;

import edu.colorado.phet.acidbasesolutions.constants.ABSImages;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.model.ABSModel;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Molecule;
import edu.colorado.phet.acidbasesolutions.model.PureWaterSolution;
import edu.colorado.phet.acidbasesolutions.model.StrongAcidSolution;
import edu.colorado.phet.acidbasesolutions.model.StrongBaseSolution;
import edu.colorado.phet.acidbasesolutions.model.WeakAcidSolution;
import edu.colorado.phet.acidbasesolutions.model.WeakBaseSolution;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingIcon;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJRadioButton;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FixedSolutionControls
extends PhetTitledPanel {
    private final ABSModel model;
    private final JRadioButton waterRadioButton;
    private final JRadioButton strongAcidRadioButton;
    private final JRadioButton weakAcidRadioButton;
    private final JRadioButton strongBaseRadioButton;
    private final JRadioButton weakBaseRadioButton;

    public FixedSolutionControls(ABSModel aBSModel) {
        super(ABSStrings.SOLUTIONS);
        this.model = aBSModel;
        this.model.addModelChangeListener(new ABSModel.ModelChangeListener(){

            public void solutionChanged() {
                FixedSolutionControls.this.updateControls();
            }
        });
        Object object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FixedSolutionControls.this.updateModel();
            }
        };
        this.waterRadioButton = new SolutionRadioButton(ABSSimSharing.UserComponents.waterRadioButton, ABSStrings.WATER, new Molecule.WaterMolecule());
        this.waterRadioButton.addActionListener((ActionListener)object);
        this.strongAcidRadioButton = new SolutionRadioButton(ABSSimSharing.UserComponents.strongAcidRadioButton, ABSStrings.STRONG_ACID, new Molecule.GenericAcidMolecule());
        this.strongAcidRadioButton.addActionListener((ActionListener)object);
        this.weakAcidRadioButton = new SolutionRadioButton(ABSSimSharing.UserComponents.weakAcidRadioButton, ABSStrings.WEAK_ACID, new Molecule.GenericAcidMolecule());
        this.weakAcidRadioButton.addActionListener((ActionListener)object);
        this.strongBaseRadioButton = new SolutionRadioButton(ABSSimSharing.UserComponents.strongBaseRadioButton, ABSStrings.STRONG_BASE, new Molecule.GenericStrongBaseMolecule());
        this.strongBaseRadioButton.addActionListener((ActionListener)object);
        this.weakBaseRadioButton = new SolutionRadioButton(ABSSimSharing.UserComponents.weakBaseRadioButton, ABSStrings.WEAK_BASE, new Molecule.GenericWeakBaseMolecule());
        this.weakBaseRadioButton.addActionListener((ActionListener)object);
        Serializable serializable = new ButtonGroup();
        serializable.add(this.waterRadioButton);
        serializable.add(this.strongAcidRadioButton);
        serializable.add(this.weakAcidRadioButton);
        serializable.add(this.strongBaseRadioButton);
        serializable.add(this.weakBaseRadioButton);
        object = new MoleculeIcon((IUserComponent)ABSSimSharing.UserComponents.waterIcon, new Molecule.WaterMolecule(), new VoidFunction0(){

            public void apply() {
                FixedSolutionControls.this.waterRadioButton.setSelected(true);
                FixedSolutionControls.this.updateModel();
            }
        });
        serializable = new MoleculeIcon((IUserComponent)ABSSimSharing.UserComponents.strongAcidIcon, new Molecule.GenericAcidMolecule(), new VoidFunction0(){

            public void apply() {
                FixedSolutionControls.this.strongAcidRadioButton.setSelected(true);
                FixedSolutionControls.this.updateModel();
            }
        });
        MoleculeIcon moleculeIcon = new MoleculeIcon((IUserComponent)ABSSimSharing.UserComponents.weakAcidIcon, new Molecule.GenericAcidMolecule(), new VoidFunction0(){

            public void apply() {
                FixedSolutionControls.this.weakAcidRadioButton.setSelected(true);
                FixedSolutionControls.this.updateModel();
            }
        });
        MoleculeIcon moleculeIcon2 = new MoleculeIcon((IUserComponent)ABSSimSharing.UserComponents.strongBaseIcon, new Molecule.GenericStrongBaseMolecule(), new VoidFunction0(){

            public void apply() {
                FixedSolutionControls.this.strongBaseRadioButton.setSelected(true);
                FixedSolutionControls.this.updateModel();
            }
        });
        MoleculeIcon moleculeIcon3 = new MoleculeIcon((IUserComponent)ABSSimSharing.UserComponents.weakBaseIcon, new Molecule.GenericWeakBaseMolecule(), new VoidFunction0(){

            public void apply() {
                FixedSolutionControls.this.weakBaseRadioButton.setSelected(true);
                FixedSolutionControls.this.updateModel();
            }
        });
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        horizontalLayoutPanel.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel.add(this.waterRadioButton);
        horizontalLayoutPanel.add((Component)object);
        HorizontalLayoutPanel horizontalLayoutPanel2 = new HorizontalLayoutPanel();
        horizontalLayoutPanel2.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel2.add(this.strongAcidRadioButton);
        horizontalLayoutPanel2.add((Component)serializable);
        HorizontalLayoutPanel horizontalLayoutPanel3 = new HorizontalLayoutPanel();
        horizontalLayoutPanel3.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel3.add(this.weakAcidRadioButton);
        horizontalLayoutPanel3.add(moleculeIcon);
        HorizontalLayoutPanel horizontalLayoutPanel4 = new HorizontalLayoutPanel();
        horizontalLayoutPanel4.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel4.add(this.strongBaseRadioButton);
        horizontalLayoutPanel4.add(moleculeIcon2);
        HorizontalLayoutPanel horizontalLayoutPanel5 = new HorizontalLayoutPanel();
        horizontalLayoutPanel5.setInsets(new Insets(0, 5, 0, 0));
        horizontalLayoutPanel5.add(this.weakBaseRadioButton);
        horizontalLayoutPanel5.add(moleculeIcon3);
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.setInsets(new Insets(4, 0, 4, 0));
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(horizontalLayoutPanel, n++, n2);
        easyGridBagLayout.addComponent(horizontalLayoutPanel2, n++, n2);
        easyGridBagLayout.addComponent(horizontalLayoutPanel3, n++, n2);
        easyGridBagLayout.addComponent(horizontalLayoutPanel4, n++, n2);
        easyGridBagLayout.addComponent(horizontalLayoutPanel5, n++, n2);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this.updateControls();
    }

    private void updateControls() {
        AqueousSolution aqueousSolution = this.model.getSolution();
        if (aqueousSolution instanceof PureWaterSolution) {
            this.waterRadioButton.setSelected(true);
        } else if (aqueousSolution instanceof StrongAcidSolution.TestStrongAcidSolution) {
            this.strongAcidRadioButton.setSelected(true);
        } else if (aqueousSolution instanceof WeakAcidSolution.TestWeakAcidSolution) {
            this.weakAcidRadioButton.setSelected(true);
        } else if (aqueousSolution instanceof StrongBaseSolution.TestStrongBaseSolution) {
            this.strongBaseRadioButton.setSelected(true);
        } else if (aqueousSolution instanceof WeakBaseSolution.TestWeakBaseSolution) {
            this.weakBaseRadioButton.setSelected(true);
        } else {
            throw new UnsupportedOperationException("unsupported solution type: " + aqueousSolution.getClass().getName());
        }
    }

    private void updateModel() {
        if (this.waterRadioButton.isSelected()) {
            this.model.setSolution(new PureWaterSolution());
        } else if (this.strongAcidRadioButton.isSelected()) {
            this.model.setSolution(new StrongAcidSolution.TestStrongAcidSolution());
        } else if (this.weakAcidRadioButton.isSelected()) {
            this.model.setSolution(new WeakAcidSolution.TestWeakAcidSolution());
        } else if (this.strongBaseRadioButton.isSelected()) {
            this.model.setSolution(new StrongBaseSolution.TestStrongBaseSolution());
        } else if (this.weakBaseRadioButton.isSelected()) {
            this.model.setSolution(new WeakBaseSolution.TestWeakBaseSolution());
        } else {
            throw new IllegalStateException("illegal state, no radio button selected");
        }
    }

    private static final class MoleculeIcon
    extends SimSharingIcon {
        public MoleculeIcon(IUserComponent iUserComponent, Molecule molecule, VoidFunction0 voidFunction0) {
            super(iUserComponent, ABSImages.createIcon(molecule.getImage(), 0.75), voidFunction0);
        }
    }

    private static class SolutionRadioButton
    extends SimSharingJRadioButton {
        public SolutionRadioButton(IUserComponent iUserComponent, String string, Molecule molecule) {
            super(iUserComponent);
            String string2 = MessageFormat.format(ABSStrings.PATTERN_SOLUTION_SYMBOL, string, molecule.getSymbol());
            String string3 = HTMLUtils.toHTMLString(string2);
            this.setText(string3);
        }
    }
}

