/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.controls;

import edu.colorado.phet.acidbasesolutions.constants.ABSConstants;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.model.ABSModel;
import edu.colorado.phet.acidbasesolutions.model.AcidSolution;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.StrongAcidSolution;
import edu.colorado.phet.acidbasesolutions.model.StrongBaseSolution;
import edu.colorado.phet.acidbasesolutions.model.WeakAcidSolution;
import edu.colorado.phet.acidbasesolutions.model.WeakBaseSolution;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJRadioButton;
import edu.colorado.phet.common.phetcommon.view.ColoredSeparator;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LogarithmicValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.SimSharingLogarithmicValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CustomSolutionControls
extends PhetTitledPanel {
    private final ABSModel model;
    private AqueousSolution solution;
    private final TypePanel typePanel;
    private final ConcentrationPanel concentrationPanel;
    private final StrengthPanel strengthPanel;
    private final AqueousSolution.AqueousSolutionChangeListener solutionChangeListener;
    private boolean isSyncingWithModel;

    public CustomSolutionControls(ABSModel aBSModel) {
        super(ABSStrings.SOLUTION);
        this.model = aBSModel;
        this.isSyncingWithModel = false;
        this.model.addModelChangeListener(new ABSModel.ModelChangeListener(){

            public void solutionChanged() {
                CustomSolutionControls.this.updateControls();
            }
        });
        this.solution = aBSModel.getSolution();
        this.solutionChangeListener = new AqueousSolution.AqueousSolutionChangeListener(){

            public void concentrationChanged() {
                CustomSolutionControls.this.updateControls();
            }

            public void strengthChanged() {
                CustomSolutionControls.this.updateControls();
            }
        };
        this.solution.addAqueousSolutionChangeListener(this.solutionChangeListener);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CustomSolutionControls.this.updateModel();
            }
        };
        this.typePanel = new TypePanel(changeListener);
        this.concentrationPanel = new ConcentrationPanel(changeListener);
        this.strengthPanel = new StrengthPanel(changeListener);
        int n = 0;
        int n2 = 0;
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setFill(2);
        easyGridBagLayout.addFilledComponent(this.typePanel, n++, n2, 2);
        easyGridBagLayout.addFilledComponent(new ColoredSeparator.BlackSeparator(), n++, n2, 2);
        easyGridBagLayout.addFilledComponent(this.concentrationPanel, n++, n2, 2);
        easyGridBagLayout.addFilledComponent(new ColoredSeparator.BlackSeparator(), n++, n2, 2);
        easyGridBagLayout.addFilledComponent(this.strengthPanel, n++, n2, 2);
        this.updateControls();
    }

    private void updateControls() {
        this.isSyncingWithModel = true;
        this.solution.removeAqueousSolutionChangeListener(this.solutionChangeListener);
        this.solution = this.model.getSolution();
        this.solution.addAqueousSolutionChangeListener(this.solutionChangeListener);
        this.typePanel.setAcidSelected(this.solution instanceof AcidSolution);
        this.concentrationPanel.setConcentration(this.model.getSolution().getConcentration());
        this.strengthPanel.setWeakSelected(this.solution instanceof WeakAcidSolution || this.solution instanceof WeakBaseSolution);
        this.strengthPanel.setStrength(this.model.getSolution().getStrength());
        this.isSyncingWithModel = false;
    }

    private void updateModel() {
        if (!this.isSyncingWithModel) {
            AqueousSolution aqueousSolution = this.model.getSolution();
            assert (aqueousSolution instanceof AqueousSolution.ICustomSolution);
            double d = this.strengthPanel.getStrength();
            double d2 = this.concentrationPanel.getConcentration();
            if (this.typePanel.isAcidSelected()) {
                if (this.strengthPanel.isWeakSelected()) {
                    if (aqueousSolution instanceof WeakAcidSolution.CustomWeakAcidSolution) {
                        ((WeakAcidSolution.CustomWeakAcidSolution)aqueousSolution).setStrength(d);
                        ((WeakAcidSolution.CustomWeakAcidSolution)aqueousSolution).setConcentration(d2);
                    } else {
                        WeakAcidSolution.CustomWeakAcidSolution customWeakAcidSolution = new WeakAcidSolution.CustomWeakAcidSolution(d, d2);
                        this.model.setSolution(customWeakAcidSolution);
                    }
                } else if (aqueousSolution instanceof StrongAcidSolution.CustomStrongAcidSolution) {
                    ((StrongAcidSolution.CustomStrongAcidSolution)aqueousSolution).setConcentration(d2);
                } else {
                    StrongAcidSolution.CustomStrongAcidSolution customStrongAcidSolution = new StrongAcidSolution.CustomStrongAcidSolution(d2);
                    this.model.setSolution(customStrongAcidSolution);
                }
            } else if (this.strengthPanel.isWeakSelected()) {
                if (aqueousSolution instanceof WeakBaseSolution.CustomWeakBaseSolution) {
                    ((WeakBaseSolution.CustomWeakBaseSolution)aqueousSolution).setStrength(d);
                    ((WeakBaseSolution.CustomWeakBaseSolution)aqueousSolution).setConcentration(d2);
                } else {
                    WeakBaseSolution.CustomWeakBaseSolution customWeakBaseSolution = new WeakBaseSolution.CustomWeakBaseSolution(d, d2);
                    this.model.setSolution(customWeakBaseSolution);
                }
            } else if (aqueousSolution instanceof StrongBaseSolution.CustomStrongBaseSolution) {
                ((StrongBaseSolution.CustomStrongBaseSolution)aqueousSolution).setConcentration(d2);
            } else {
                StrongBaseSolution.CustomStrongBaseSolution customStrongBaseSolution = new StrongBaseSolution.CustomStrongBaseSolution(d2);
                this.model.setSolution(customStrongBaseSolution);
            }
        }
    }

    private static class ChangeablePanel
    extends JPanel {
        private final ChangeListener listener;

        public ChangeablePanel(ChangeListener changeListener) {
            this.listener = changeListener;
        }

        protected void fireStateChanged() {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    private static class ConcentrationPanel
    extends ChangeablePanel {
        private final LogarithmicValueControl concentrationControl;

        public ConcentrationPanel(ChangeListener changeListener) {
            super(changeListener);
            double d = ABSConstants.CONCENTRATION_RANGE.getMin();
            double d2 = ABSConstants.CONCENTRATION_RANGE.getMax();
            double d3 = ABSConstants.CONCENTRATION_RANGE.getDefault();
            String string = ABSStrings.INITIAL_CONCENTRATION;
            String string2 = "0.000";
            String string3 = ABSStrings.MOLES_PER_LITER;
            this.concentrationControl = new SimSharingLogarithmicValueControl(ABSSimSharing.UserComponents.concentrationControl, d, d2, string, string2, string3);
            this.concentrationControl.setValue(d3);
            this.concentrationControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    ConcentrationPanel.this.fireStateChanged();
                }
            });
            Serializable serializable = new Hashtable<Double, JLabel>();
            DecimalFormat decimalFormat = new DecimalFormat("#.###");
            int n = 0;
            for (double d4 = this.concentrationControl.getMinimum(); d4 <= this.concentrationControl.getMaximum(); d4 *= 10.0) {
                ((Hashtable)serializable).put(new Double(d4), new JLabel(decimalFormat.format(d4)));
                ++n;
            }
            this.concentrationControl.setTickLabels((Hashtable)serializable);
            int n2 = (this.concentrationControl.getSlider().getMaximum() - this.concentrationControl.getSlider().getMinimum()) / (n - 1);
            this.concentrationControl.getSlider().setMajorTickSpacing(n2);
            serializable = new EasyGridBagLayout(this);
            ((EasyGridBagLayout)serializable).setInsets(new Insets(0, 0, 0, 0));
            this.setLayout((LayoutManager)((Object)serializable));
            int n3 = 0;
            n = 0;
            ((EasyGridBagLayout)serializable).addComponent(this.concentrationControl, n3, n);
        }

        public void setConcentration(double d) {
            this.concentrationControl.setValue(d);
        }

        public double getConcentration() {
            return this.concentrationControl.getValue();
        }
    }

    private static class SliderLayoutStrategy
    implements ILayoutStrategy {
        public void doLayout(AbstractValueControl abstractValueControl) {
            abstractValueControl.add(abstractValueControl.getSlider());
        }
    }

    private static class StrengthPanel
    extends ChangeablePanel {
        private final JRadioButton weakRadioButton;
        private final JRadioButton strongRadioButton;
        private final LogarithmicValueControl weakStrengthControl;

        public StrengthPanel(ChangeListener changeListener) {
            super(changeListener);
            JLabel jLabel = new JLabel(ABSStrings.STRENGTH);
            ButtonGroup buttonGroup = new ButtonGroup();
            Object object = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StrengthPanel.this.fireStateChanged();
                }
            };
            this.weakRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.weakRadioButton, ABSStrings.WEAK);
            buttonGroup.add(this.weakRadioButton);
            this.weakRadioButton.addActionListener((ActionListener)object);
            this.strongRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.strongRadioButton, ABSStrings.STRONG);
            buttonGroup.add(this.strongRadioButton);
            this.strongRadioButton.addActionListener((ActionListener)object);
            double d = ABSConstants.WEAK_STRENGTH_RANGE.getMin();
            double d2 = ABSConstants.WEAK_STRENGTH_RANGE.getMax();
            double d3 = ABSConstants.WEAK_STRENGTH_RANGE.getDefault();
            String string = "";
            String string2 = "";
            String string3 = "";
            this.weakStrengthControl = new SimSharingLogarithmicValueControl(ABSSimSharing.UserComponents.weakStrengthControl, d, d2, string, string2, string3, new SliderLayoutStrategy());
            this.weakStrengthControl.setValue(d3);
            Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
            hashtable.put(new Double(this.weakStrengthControl.getMinimum()), new JLabel(ABSStrings.WEAKER));
            hashtable.put(new Double(this.weakStrengthControl.getMaximum()), new JLabel(ABSStrings.STRONGER));
            this.weakStrengthControl.setTickLabels(hashtable);
            this.weakStrengthControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    StrengthPanel.this.fireStateChanged();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(this.weakRadioButton);
            jPanel.add(this.strongRadioButton);
            object = new EasyGridBagLayout(this);
            ((EasyGridBagLayout)object).setInsets(new Insets(0, 0, 0, 0));
            this.setLayout((LayoutManager)object);
            int n = 0;
            int n2 = 0;
            ((EasyGridBagLayout)object).addComponent(jLabel, n++, n2);
            ((EasyGridBagLayout)object).addAnchoredComponent(jPanel, n++, n2++, 10);
            n2 = 0;
            ((EasyGridBagLayout)object).addAnchoredComponent(this.weakStrengthControl, n, n2++, 10);
            ((EasyGridBagLayout)object).addComponent(Box.createVerticalStrut(this.weakStrengthControl.getPreferredSize().height), n++, n2);
            n2 = 0;
            ((EasyGridBagLayout)object).addComponent(Box.createHorizontalStrut(this.weakStrengthControl.getPreferredSize().width), n, n2);
        }

        public void setWeakSelected(boolean bl) {
            this.weakRadioButton.setSelected(bl);
            this.weakStrengthControl.setVisible(bl);
        }

        public boolean isWeakSelected() {
            return this.weakRadioButton.isSelected();
        }

        public void setStrength(double d) {
            if (ABSConstants.WEAK_STRENGTH_RANGE.contains(d)) {
                this.weakStrengthControl.setValue(d);
            }
        }

        public double getStrength() {
            return this.weakStrengthControl.getValue();
        }
    }

    private static class TypePanel
    extends ChangeablePanel {
        private final JRadioButton acidRadioButton;
        private final JRadioButton baseRadioButton;

        public TypePanel(ChangeListener changeListener) {
            super(changeListener);
            Serializable serializable = new ButtonGroup();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TypePanel.this.fireStateChanged();
                }
            };
            this.acidRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.acidRadioButton, ABSStrings.ACID);
            ((ButtonGroup)serializable).add(this.acidRadioButton);
            this.acidRadioButton.addActionListener(actionListener);
            this.baseRadioButton = new SimSharingJRadioButton(ABSSimSharing.UserComponents.baseRadioButton, ABSStrings.BASE);
            ((ButtonGroup)serializable).add(this.baseRadioButton);
            this.baseRadioButton.addActionListener(actionListener);
            serializable = new EasyGridBagLayout(this);
            this.setLayout((LayoutManager)((Object)serializable));
            int n = 0;
            int n2 = 0;
            ((EasyGridBagLayout)serializable).addComponent(this.acidRadioButton, n, n2++);
            ((EasyGridBagLayout)serializable).addComponent(this.baseRadioButton, n, n2++);
        }

        public void setAcidSelected(boolean bl) {
            this.acidRadioButton.setSelected(bl);
        }

        public boolean isAcidSelected() {
            return this.acidRadioButton.isSelected();
        }
    }
}

