/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.constants;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class ABSConstants {
    public static final Dimension CANVAS_RENDERING_SIZE = new Dimension(900, 900);
    public static final DoubleRange CONCENTRATION_RANGE = new DoubleRange(0.001, 1.0, 0.01);
    public static final DoubleRange WEAK_STRENGTH_RANGE = new DoubleRange(1.0E-10, 100.0, 1.0E-7);
    public static final double STRONG_STRENGTH = WEAK_STRENGTH_RANGE.getMax() + 1.0;
    public static final PDimension BEAKER_SIZE = new PDimension(700.0, 540.0);
    public static final Point2D BEAKER_LOCATION = new Point2D.Double(0.0, 0.0);
    public static final Point2D PH_METER_LOCATION = new Point2D.Double(BEAKER_LOCATION.getX() + 0.3 * BEAKER_SIZE.getWidth(), BEAKER_LOCATION.getY() - BEAKER_SIZE.getHeight() - 15.0);
    public static final PDimension PH_METER_SHAFT_SIZE = new PDimension(10.0, 100.0);
    public static final PDimension PH_METER_TIP_SIZE = new PDimension(25.0, 60.0);
    public static final PDimension PH_PAPER_SIZE = new PDimension(30.0, 220.0);
    public static final Point2D PH_PAPER_LOCATION = new Point2D.Double(BEAKER_LOCATION.getX() + 170.0, BEAKER_LOCATION.getY() - BEAKER_SIZE.getHeight() - PH_PAPER_SIZE.getHeight() - 15.0);
    public static final Point2D PH_COLOR_KEY_LOCATION = new Point2D.Double(BEAKER_LOCATION.getX() - BEAKER_SIZE.getWidth() / 2.0 + 55.0, PH_PAPER_LOCATION.getY());
    public static final PDimension CONDUCTIVITY_TESTER_PROBE_SIZE = new PDimension(30.0, 100.0);
    public static final Point2D CONDUCTIVITY_TESTER_LOCATION = new Point2D.Double(BEAKER_LOCATION.getX() - 70.0, BEAKER_LOCATION.getY() - BEAKER_SIZE.getHeight() - 70.0);
    public static final Point2D CONDUCTIVITY_TESTER_POSITIVE_PROBE_LOCATION = new Point2D.Double(CONDUCTIVITY_TESTER_LOCATION.getX() + 230.0, BEAKER_LOCATION.getY() - BEAKER_SIZE.getHeight() - 20.0);
    public static final Point2D CONDUCTIVITY_TESTER_NEGATIVE_PROBE_LOCATION = new Point2D.Double(CONDUCTIVITY_TESTER_LOCATION.getX() - 95.0, BEAKER_LOCATION.getY() - BEAKER_SIZE.getHeight() - 20.0);
    public static final Point2D MAGNIFYING_GLASS_LOCATION = new Point2D.Double(BEAKER_LOCATION.getX(), BEAKER_LOCATION.getY() - BEAKER_SIZE.getHeight() / 2.0);
    public static final Point2D CONCENTRATION_GRAPH_LOCATION = new Point2D.Double(BEAKER_LOCATION.getX(), BEAKER_LOCATION.getY() - BEAKER_SIZE.getHeight() / 2.0);
    public static final PDimension CONCENTRATION_GRAPH_SIZE = new PDimension(360.0, BEAKER_SIZE.getHeight() - 50.0);
    public static final Point2D REACTION_EQUATION_LOCATION = new Point2D.Double(BEAKER_LOCATION.getX(), BEAKER_LOCATION.getY() + 10.0);
}

