/*
 * Decompiled with CFR 0.152.
 */
package org.cove.jade.primitives;

import org.cove.jade.DynamicsEngine;
import org.cove.jade.surfaces.Surface;
import org.cove.jade.util.GVector;

public class Particle {
    public GVector curr;
    public GVector prev;
    public double bmin;
    public double bmax;
    public GVector mtd;
    public double bounciness;
    public double mass;
    protected GVector init;
    protected GVector temp;
    protected GVector extents;
    protected boolean isVisible;
    private double ax;
    private double ay;

    public Particle(double d, double d2) {
        this.init = new GVector(d, d2);
        this.curr = new GVector(d, d2);
        this.prev = new GVector(d, d2);
        this.temp = new GVector(0.0, 0.0);
        this.extents = new GVector(0.0, 0.0);
        this.bmin = 0.0;
        this.bmax = 0.0;
        this.mtd = new GVector(0.0, 0.0);
        this.mass = 1.0;
        this.bounciness = 1.0;
        this.isVisible = true;
    }

    public void setAcceleration(double d, double d2) {
        this.ax = d;
        this.ay = d2;
    }

    public void verlet(DynamicsEngine dynamicsEngine) {
        this.temp.x = this.curr.x;
        this.temp.y = this.curr.y;
        this.curr.x += dynamicsEngine.coeffDamp * (this.curr.x - this.prev.x) + (dynamicsEngine.gravity.x + this.ax) * this.mass;
        this.curr.y += dynamicsEngine.coeffDamp * (this.curr.y - this.prev.y) + (dynamicsEngine.gravity.y + this.ay) * this.mass;
        this.prev.x = this.temp.x;
        this.prev.y = this.temp.y;
    }

    public void resolveCollision(GVector gVector, DynamicsEngine dynamicsEngine) {
        GVector gVector2 = this.curr.minusNew(this.prev);
        double d = gVector.dot(gVector2);
        GVector gVector3 = gVector2.minusNew(gVector.multNew(d));
        GVector gVector4 = gVector3.multNew(dynamicsEngine.coeffFric);
        GVector gVector5 = gVector.multNew(d * dynamicsEngine.coeffRest * this.bounciness);
        GVector gVector6 = gVector5.plusNew(gVector4);
        GVector gVector7 = gVector2.minusNew(gVector6);
        this.curr.plus(this.mtd);
        this.prev = this.curr.minusNew(gVector7);
    }

    public void checkCollision(Surface surface, DynamicsEngine dynamicsEngine) {
    }
}

