/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.travoltage.ArmNode;
import edu.colorado.phet.travoltage.DoorknobNode;
import edu.colorado.phet.travoltage.JadeElectron;
import edu.colorado.phet.travoltage.LegNode;
import edu.colorado.phet.travoltage.PickUpElectrons;
import edu.colorado.phet.travoltage.SparkManager;
import edu.colorado.phet.travoltage.TravoltageAudio;
import edu.colorado.phet.travoltage.TravoltageModel;
import edu.colorado.phet.travoltage.TravoltagePanel;

public class TravoltageModule
extends PiccoloModule {
    private TravoltagePanel travoltagePanel;
    private TravoltageModel travoltageModel = new TravoltageModel(this);
    private TravoltageAudio travoltageAudio;

    public TravoltageModule() {
        super("Travoltage", TravoltageModule.createClock());
        this.setModel(this.travoltageModel);
        this.travoltagePanel = new TravoltagePanel(this);
        this.setSimulationPanel(this.travoltagePanel);
        this.travoltageAudio = new TravoltageAudio(this.travoltageModel);
        this.getLegNode().addListener(new PickUpElectrons(this, this.getLegNode()));
        this.travoltageModel.addModelElement(new SparkManager(this.getArmNode(), this.getDoorknobNode(), this.travoltageModel.getJadeElectronSet(), this));
        this.setClockControlPanel(null);
    }

    public void activate() {
        super.activate();
        this.getTravoltagePanel().showHelpBalloon();
    }

    private DoorknobNode getDoorknobNode() {
        return this.travoltagePanel.getTravoltageRootNode().getDoorknobNode();
    }

    public LegNode getLegNode() {
        return this.travoltagePanel.getTravoltageRootNode().getTravoltageBodyNode().getLegNode();
    }

    public TravoltagePanel getTravoltagePanel() {
        return this.travoltagePanel;
    }

    public TravoltageModel getTravoltageModel() {
        return this.travoltageModel;
    }

    private static IClock createClock() {
        return new SwingClock(30, 1.0);
    }

    public void pickUpElectron() {
        this.travoltagePanel.getTravoltageRootNode().pickUpElectron();
    }

    public ArmNode getArmNode() {
        return this.travoltagePanel.getTravoltageRootNode().getTravoltageBodyNode().getArmNode();
    }

    public void addElectron(JadeElectron jadeElectron) {
        this.travoltageModel.addElectron(jadeElectron);
    }

    public void fireSpark() {
        this.travoltageModel.startSpark();
    }
}

