/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.travoltage.ArmNode;
import edu.colorado.phet.travoltage.DoorknobNode;
import edu.colorado.phet.travoltage.LimbNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Random;
import java.util.Vector;

public class SparkNode
extends PNode {
    private Point2D source;
    private Point2D sink;
    private double maxDTheta;
    private Random random;
    private double threshold;
    private IClock clock;
    private ArmNode armNode;
    private DoorknobNode doorknobNode;
    private double segLength;

    public SparkNode(ArmNode armNode, DoorknobNode doorknobNode, double d, double d2, double d3, IClock iClock) {
        this.armNode = armNode;
        this.doorknobNode = doorknobNode;
        this.segLength = d3;
        this.maxDTheta = d;
        this.threshold = d2;
        this.clock = iClock;
        this.random = new Random();
        this.sink = doorknobNode.getGlobalKnobPoint();
        this.updateSource();
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                SparkNode.this.update();
            }
        });
        armNode.addListener(new LimbNode.Listener(){

            public void limbRotated() {
                SparkNode.this.updateSource();
            }
        });
        this.updateSource();
    }

    private void updateSource() {
        Point2D point2D = this.armNode.getGlobalFingertipPoint();
        point2D = this.globalToLocal(point2D);
        this.setSource(point2D);
    }

    private void setSource(Point2D point2D) {
        this.source = point2D;
        this.update();
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.getVisible();
        super.setVisible(bl);
        if (bl2 != bl) {
            this.update();
        }
    }

    private void update() {
        if (this.getVisible()) {
            this.removeAllChildren();
            Point2D[] point2DArray = this.newPath(100);
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            for (int i = 0; i < point2DArray.length; ++i) {
                if (i == 0) {
                    doubleGeneralPath.moveTo(point2DArray[i].getX(), point2DArray[i].getY());
                    continue;
                }
                doubleGeneralPath.lineTo(point2DArray[i].getX(), point2DArray[i].getY());
            }
            PPath pPath = new PPath(doubleGeneralPath.getGeneralPath());
            pPath.setStroke(new BasicStroke(4.0f));
            pPath.setStrokePaint(Color.white);
            this.addChild(pPath);
            PPath pPath2 = new PPath(doubleGeneralPath.getGeneralPath());
            pPath2.setStroke(new BasicStroke(1.0f));
            pPath2.setStrokePaint(Color.blue);
            this.addChild(pPath2);
        }
    }

    public Point2D[] newPath(int n) {
        Vector<Point2D> vector = new Vector<Point2D>();
        Point2D point2D = this.source;
        vector.add(this.source);
        for (int i = 0; i < n; ++i) {
            if (point2D.distance(this.sink) < this.threshold) {
                vector.add(this.sink);
                break;
            }
            Point2D point2D2 = this.nextPoint(point2D);
            if (point2D2 == null) break;
            vector.add(point2D2);
            point2D = point2D2;
        }
        return vector.toArray(new Point2D[0]);
    }

    public double getAngle(double d, double d2) {
        return Math.atan2(d2, d);
    }

    public Point2D nextPoint(Point2D point2D) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.sink.getX(), point2D.getY() - this.sink.getY());
        double d = this.getAngle(((Point2D)double_).getX(), ((Point2D)double_).getY());
        double d2 = (this.random.nextDouble() - 0.5) * 2.0 * this.maxDTheta;
        double d3 = d + d2;
        return new Point2D.Double(point2D.getX() - this.segLength * Math.cos(d3), point2D.getY() - this.segLength * Math.sin(d3));
    }
}

