/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.travoltage.ArmNode;
import edu.colorado.phet.travoltage.DoorknobNode;
import edu.colorado.phet.travoltage.JadeElectronSet;
import edu.colorado.phet.travoltage.TravoltageModule;

public class SparkManager
implements ModelElement {
    int[] numElectrons = new int[]{10, 15, 20, 35, 30, 35, 40, 50, 60, 70};
    double[] dist = new double[]{20.0, 30.0, 40.0, 40.0, 60.0, 70.0, 80.0, 100.0, 120.0, 140.0};
    private ArmNode armNode;
    private DoorknobNode doorknobNode;
    JadeElectronSet jadeElectronSet;
    private TravoltageModule travoltageModule;

    public SparkManager(ArmNode armNode, DoorknobNode doorknobNode, JadeElectronSet jadeElectronSet, TravoltageModule travoltageModule) {
        this.armNode = armNode;
        this.doorknobNode = doorknobNode;
        this.jadeElectronSet = jadeElectronSet;
        this.travoltageModule = travoltageModule;
    }

    private boolean shouldFire() {
        double d = this.getFingerKnobDistance();
        int n = (int)((double)this.jadeElectronSet.getNumElectrons() / 2.0);
        for (int i = 0; i < this.numElectrons.length; ++i) {
            if (n <= this.numElectrons[i] || !(d < this.dist[i])) continue;
            return true;
        }
        return false;
    }

    private double getFingerKnobDistance() {
        return this.armNode.getGlobalFingertipPoint().distance(this.doorknobNode.getGlobalKnobPoint());
    }

    public void stepInTime(double d) {
        if (this.shouldFire()) {
            this.fireSpark();
        }
    }

    private void fireSpark() {
        this.travoltageModule.fireSpark();
    }
}

