/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.travoltage.JadeElectron;
import edu.colorado.phet.travoltage.JadeElectronSet;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.cove.jade.DynamicsEngine;
import org.cove.jade.surfaces.LineSurface;

public class MoveElectronsJade
implements ModelElement {
    private JadeElectronSet jadeElectronSet;
    private DynamicsEngine engine;
    private DoubleGeneralPath path;
    private Area area;
    private boolean debug = true;
    int count = 0;

    public MoveElectronsJade(JadeElectronSet jadeElectronSet) {
        Point2D.Double double_;
        int n;
        this.jadeElectronSet = jadeElectronSet;
        jadeElectronSet.addListener(new JadeElectronSet.Adapter(){

            public void electronAdded(JadeElectron jadeElectron) {
                MoveElectronsJade.this.engine.addPrimitive(jadeElectron);
            }

            public void electronRemoved(JadeElectron jadeElectron) {
                MoveElectronsJade.this.engine.removePrimitive(jadeElectron);
            }
        });
        this.engine = new DynamicsEngine();
        this.engine.setDamping(0.95);
        this.engine.setGravity(0.0, 0.0);
        this.engine.setSurfaceBounce(0.9);
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        StringTokenizer stringTokenizer = new StringTokenizer("163\t200\n165\t224\n186\t252\n187\t269\n208\t335\n223\t351\n242\t350\n262\t338\n276\t345\n218\t402\n192\t377\n181\t371\n147\t293\n129\t273\n86\t366\n95\t381\n123\t390\n128\t401\n91\t404\n46\t402\n44\t360\n83\t274\n46\t234\n4\t218\n4\t198\n24\t140\n77\t65\n111\t48\n133\t48\n137\t40\n145\t40\n164\t10\n186\t7\n212\t19\n211\t28\n206\t32\n200\t50\n202\t61\n191\t77\n173\t74\n167\t79\n174\t94\n181\t107\n183\t123\n190\t136\n207\t145\n286\t120\n298\t135\n296\t144\n275\t150\n270\t169\n200\t183\n172\t172\n162\t200", "\n\t");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Point2D.Double(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())));
        }
        for (n = 1; n < arrayList.size(); ++n) {
            double_ = (Point2D.Double)arrayList.get(n - 1);
            Point2D.Double double_2 = (Point2D.Double)arrayList.get(n);
            LineSurface lineSurface = new LineSurface(double_2.getX(), double_2.getY(), double_.getX(), double_.getY());
            lineSurface.setCollisionDepth(25.0);
            this.engine.addSurface(lineSurface);
        }
        this.path = new DoubleGeneralPath();
        for (n = 0; n < arrayList.size(); ++n) {
            double_ = (Point2D.Double)arrayList.get(n);
            if (n == 0) {
                this.path.moveTo(double_.getX(), double_.getY());
                continue;
            }
            this.path.lineTo(double_.getX(), double_.getY());
        }
        this.path.closePath();
        this.area = new Area(this.path.getGeneralPath());
    }

    protected DynamicsEngine getEngine() {
        return this.engine;
    }

    protected ImmutableVector2D getForce(JadeElectron jadeElectron) {
        Vector2D vector2D = new Vector2D();
        for (int i = 0; i < this.jadeElectronSet.getNumElectrons(); ++i) {
            JadeElectron jadeElectron2 = this.jadeElectronSet.getJadeElectron(i);
            if (jadeElectron2 == jadeElectron) continue;
            vector2D = vector2D.add(this.getForce(jadeElectron, jadeElectron2));
        }
        if (this.isLegal(vector2D)) {
            return vector2D;
        }
        return new Vector2D();
    }

    private boolean isLegal(Vector2D vector2D) {
        return !Double.isInfinite(vector2D.getX()) && !Double.isNaN(vector2D.getX()) && !Double.isInfinite(vector2D.getY()) && !Double.isNaN(vector2D.getY());
    }

    protected ImmutableVector2D getForce(JadeElectron jadeElectron, JadeElectron jadeElectron2) {
        return this.getForce(jadeElectron, jadeElectron2, 5.0);
    }

    protected ImmutableVector2D getForce(JadeElectron jadeElectron, JadeElectron jadeElectron2, double d) {
        Vector2D vector2D = new Vector2D(jadeElectron.getPosition(), jadeElectron2.getPosition());
        if (vector2D.getMagnitude() <= 1.0) {
            return new Vector2D();
        }
        ImmutableVector2D immutableVector2D = vector2D.getInstanceOfMagnitude(-d / Math.pow(vector2D.getMagnitude(), 1.5));
        double d2 = 0.05;
        if (immutableVector2D.getMagnitude() > d2) {
            immutableVector2D = immutableVector2D.getInstanceOfMagnitude(d2);
        }
        return immutableVector2D;
    }

    public void stepInTime(double d) {
        int n;
        for (n = 0; n < this.jadeElectronSet.getNumElectrons(); ++n) {
            JadeElectron jadeElectron = this.jadeElectronSet.getJadeElectron(n);
            ImmutableVector2D immutableVector2D = this.getForce(jadeElectron);
            jadeElectron.setAcceleration(immutableVector2D.getX(), immutableVector2D.getY());
        }
        this.engine.timeStep();
        for (n = 0; n < this.jadeElectronSet.getNumElectrons(); ++n) {
            this.jadeElectronSet.getJadeElectron(n).notifyElectronMoved();
        }
        this.testRemove();
        ++this.count;
    }

    private void testRemove() {
        int n = 0;
        for (int i = 0; i < this.jadeElectronSet.getNumElectrons(); ++i) {
            if (!this.isProblematic(this.jadeElectronSet.getJadeElectron(i))) continue;
            ++n;
            if (this.contains(this.jadeElectronSet.getJadeElectron(i))) continue;
            if (this.debug) {
                System.out.println("Removed bogus electron.");
            }
            this.remove(i);
            --i;
        }
        if (this.debug && n > 0) {
            System.out.println("problemCount total= " + n);
        }
    }

    private boolean isProblematic(JadeElectron jadeElectron) {
        return jadeElectron.getPosition().getX() > 266.0 && jadeElectron.getPosition().getY() > 300.0;
    }

    private void remove(int n) {
        this.jadeElectronSet.removeElectron(n);
    }

    private boolean contains(JadeElectron jadeElectron) {
        return this.area.contains(jadeElectron.getPosition());
    }
}

