/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.travoltage.HighlightNode;
import edu.colorado.phet.travoltage.RotationHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class LimbNode
extends PNode {
    private Point pivot;
    private PImage imageNode;
    private double angle = 0.0;
    private ArrayList listeners = new ArrayList();
    private HighlightNode highlight;

    public LimbNode(String string, Point point) {
        this.imageNode = PImageFactory.create(string);
        this.addChild(this.imageNode);
        this.highlight = new HighlightNode(this.imageNode.getImage());
        this.addChild(this.highlight);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                super.mousePressed(pInputEvent);
                if (LimbNode.this.highlight.getVisible()) {
                    LimbNode.this.highlight.setVisible(false);
                    LimbNode.this.removeChild(LimbNode.this.highlight);
                }
            }
        });
        this.pivot = point;
        this.addInputEventListener(new RotationHandler(this));
        this.addInputEventListener(new CursorHandler());
    }

    protected PImage getImageNode() {
        return this.imageNode;
    }

    public Point getPivot() {
        return new Point(this.pivot);
    }

    public double getAngleGlobal(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(this.pivot.x, this.pivot.y);
        this.localToGlobal(double_);
        Vector2D vector2D = new Vector2D(new Point2D.Double(d, d2), double_);
        return vector2D.getAngle();
    }

    public void rotateAboutPivot(double d) {
        this.angle += d;
        this.rotateAboutPoint(d, this.pivot);
        this.notifyListeners();
    }

    public void setAngle(double d) {
        this.rotateAboutPivot(d - this.angle);
    }

    public Point2D getGlobalPivot() {
        return this.localToGlobal(new Point2D.Double(this.pivot.getX(), this.pivot.getY()));
    }

    public double getAngle() {
        return this.angle;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.limbRotated();
        }
    }

    public static interface Listener {
        public void limbRotated();
    }
}

