/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.travoltage.JadeElectron;
import edu.colorado.phet.travoltage.JadeElectronNode;
import edu.colorado.phet.travoltage.JadeElectronSet;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class ElectronSetNode
extends PNode {
    private ArrayList listeners = new ArrayList();

    public ElectronSetNode(JadeElectronSet jadeElectronSet) {
        jadeElectronSet.addListener(new JadeElectronSet.Listener(){

            public void electronAdded(JadeElectron jadeElectron) {
            }

            public void electronRemoved(JadeElectron jadeElectron) {
                ElectronSetNode.this.removeElectronNode(jadeElectron);
            }
        });
    }

    private void removeElectronNode(JadeElectron jadeElectron) {
        for (int i = 0; i < this.getNumElectrons(); ++i) {
            if (this.getElectronNode(i).getJadeElectron() != jadeElectron) continue;
            this.removeChild(this.getElectronNode(i));
            --i;
        }
    }

    public void addElectronNode(JadeElectronNode jadeElectronNode) {
        this.addChild(jadeElectronNode);
        this.notifyListeners(jadeElectronNode);
    }

    public int getNumElectrons() {
        return this.getChildrenCount();
    }

    public JadeElectronNode getElectronNode(int n) {
        return (JadeElectronNode)this.getChild(n);
    }

    public void notifyListeners(JadeElectronNode jadeElectronNode) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.electronAdded(jadeElectronNode);
        }
    }

    public static interface Listener {
        public void electronAdded(JadeElectronNode var1);
    }
}

