/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view.plot;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.LinearTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.common.BorderPNode;
import edu.colorado.phet.theramp.common.Range2D;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModel;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModelListenerAdapter;
import edu.colorado.phet.theramp.view.EarthGraphic;
import edu.colorado.phet.theramp.view.RampFontSet;
import edu.colorado.phet.theramp.view.RampLookAndFeel;
import edu.colorado.phet.theramp.view.plot.TimeSeriesPNode;
import edu.colorado.phet.theramp.view.plot.ZoomButton;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TimePlotSuitePNode
extends PhetPNode {
    private RampModule module;
    private PSwingCanvas pCanvas;
    private Range2D range;
    private TimeSeriesModel timeSeriesModel;
    private XYDataset dataset;
    private XYPlot plot;
    private BufferedImage bufferedImage;
    private PImage chartGraphic;
    private JFreeChart chart;
    private int chartHeight;
    private PPath cursorPNode;
    private PNode minButNode;
    private PNode maxButNode;
    private ArrayList series = new ArrayList();
    private boolean minimized = false;
    private ArrayList listeners = new ArrayList();
    private int chartWidth = 700;
    private PSwing zoomInGraphic;
    private PSwing zoomOutGraphic;
    private int zoomButtonHeight = 17;
    private SliderGraphic slider;
    private int layoutCount = 0;
    private double defaultMaxY;
    private String units;
    private Rectangle2D savedDataArea;
    private boolean dataAreaDirty = true;
    private boolean layoutDirty = true;

    public TimePlotSuitePNode(RampModule rampModule, PSwingCanvas pSwingCanvas, Range2D range2D, String string, String string2, final TimeSeriesModel timeSeriesModel, int n, boolean bl) {
        this.units = string2;
        this.defaultMaxY = range2D.getMaxY();
        this.module = rampModule;
        this.pCanvas = pSwingCanvas;
        this.range = range2D;
        this.chartHeight = n;
        this.timeSeriesModel = timeSeriesModel;
        this.dataset = TimePlotSuitePNode.createDataset();
        this.chart = TimePlotSuitePNode.createChart(range2D, this.dataset, string + " (" + string2 + ")");
        this.plot = (XYPlot)this.chart.getPlot();
        this.chartGraphic = new PImage();
        this.updateChartBuffer();
        this.addChild(this.chartGraphic);
        timeSeriesModel.addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                TimePlotSuitePNode.this.cursorPNode.setVisible(true);
                TimePlotSuitePNode.this.updateCursorLocation();
            }
        });
        timeSeriesModel.addListener(new TimeSeriesModelListenerAdapter(){

            public void recordingStarted() {
                TimePlotSuitePNode.this.hideCursor();
            }

            public void recordingPaused() {
                TimePlotSuitePNode.this.showCursor();
            }

            public void playbackStarted() {
                TimePlotSuitePNode.this.showCursor();
            }

            public void playbackPaused() {
                TimePlotSuitePNode.this.showCursor();
            }

            public void playbackFinished() {
                TimePlotSuitePNode.this.showCursor();
            }

            public void reset() {
                TimePlotSuitePNode.this.hideCursor();
            }

            public void rewind() {
                TimePlotSuitePNode.this.showCursor();
            }
        });
        Rectangle2D rectangle2D = this.getDataArea();
        int n2 = 6;
        this.cursorPNode = new PPath(new Rectangle2D.Double(-n2 / 2, -rectangle2D.getHeight() / 2.0, n2, rectangle2D.getHeight()));
        this.cursorPNode.setVisible(false);
        this.cursorPNode.setStroke(new BasicStroke(1.0f));
        this.cursorPNode.setPaint(new Color(0, 0, 0, 0));
        this.cursorPNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                double d = pInputEvent.getPositionRelativeTo(TimePlotSuitePNode.this).getX();
                Point2D point2D = TimePlotSuitePNode.this.toLinearFunction().getInverseTransform().transform(new Point2D.Double(d, 0.0), null);
                double d2 = point2D.getX();
                if (d2 < 0.0) {
                    d2 = 0.0;
                } else if (d2 > timeSeriesModel.getRecordTime()) {
                    d2 = timeSeriesModel.getRecordTime();
                }
                timeSeriesModel.setReplayTime(d2);
                System.out.println("out = " + point2D);
            }
        });
        this.cursorPNode.addInputEventListener(new CursorHandler(12));
        this.addChild(this.cursorPNode);
        JButton jButton = null;
        try {
            jButton = new JButton(new ImageIcon(ImageLoader.loadBufferedImage("the-ramp/images/min15.jpg")));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TimePlotSuitePNode.this.setMinimized(true);
                }
            });
            jButton.setMargin(new Insets(2, 2, 2, 2));
            this.minButNode = new PSwing(jButton);
            this.minButNode.setOffset(1.0, 1.0);
            this.addChild(this.minButNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JButton jButton2 = new JButton(MessageFormat.format(TheRampStrings.getString("readout.graph-name"), string));
        jButton2.setFont(RampFontSet.getFontSet().getNormalButtonFont());
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimePlotSuitePNode.this.setMinimized(false);
            }
        });
        jButton2.setBackground(EarthGraphic.earthGreen);
        this.maxButNode = new PSwing(jButton2);
        this.addChild(this.maxButNode);
        double d = this.getMaxRangeValue();
        double d2 = d / 10.0;
        double d3 = d / 100.0;
        try {
            final ZoomButton zoomButton = new ZoomButton(new ImageIcon(this.loadZoomInImage()), -d2, -d3, 100.0, d * 4.0, d, TheRampStrings.getString("camera.zoom-in"));
            this.zoomInGraphic = new PSwing(zoomButton);
            this.addChild(this.zoomInGraphic);
            final ZoomButton zoomButton2 = new ZoomButton(new ImageIcon(this.loadZoomOutImage()), d2, d3, 100.0, d * 4.0, d, TheRampStrings.getString("camera.zoom-out"));
            zoomButton2.addListener(new ZoomButton.Listener(){

                public void zoomChanged() {
                    double d = zoomButton2.getValue();
                    TimePlotSuitePNode.this.setChartRange(0, -d, 30, d);
                    zoomButton.setValue(d);
                }
            });
            this.zoomOutGraphic = new PSwing(zoomButton2);
            this.addChild(this.zoomOutGraphic);
            zoomButton.addListener(new ZoomButton.Listener(){

                public void zoomChanged() {
                    double d = zoomButton.getValue();
                    TimePlotSuitePNode.this.setChartRange(0, -d, 30, d);
                    zoomButton2.setValue(d);
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bl) {
            this.slider = this.createSlider();
        }
        this.invalidateLayout();
        this.setMinimizedState(false);
    }

    public double getTopY() {
        Point2D point2D = this.isMinimized() ? this.maxButNode.getGlobalFullBounds().getOrigin() : this.chartGraphic.getGlobalFullBounds().getOrigin();
        this.pCanvas.getCamera().globalToLocal(point2D);
        return point2D.getY();
    }

    public void updateReadouts() {
        for (int i = 0; i < this.series.size(); ++i) {
            TimeSeriesPNode timeSeriesPNode = (TimeSeriesPNode)this.series.get(i);
            timeSeriesPNode.updateReadout();
        }
    }

    private SliderGraphic createSlider() {
        Rectangle2D rectangle2D = this.getDataArea(this.plot);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        SliderGraphic sliderGraphic = new SliderGraphic(double_, this);
        return sliderGraphic;
    }

    private BufferedImage loadZoomInImage() throws IOException {
        return BufferedImageUtils.rescaleYMaintainAspectRatio(ImageLoader.loadBufferedImage("the-ramp/images/icons/glass-20-plus.gif"), this.zoomButtonHeight);
    }

    private BufferedImage loadZoomOutImage() throws IOException {
        return BufferedImageUtils.rescaleYMaintainAspectRatio(ImageLoader.loadBufferedImage("the-ramp/images/icons/glass-20-minus.gif"), this.zoomButtonHeight);
    }

    private double getMinRangeValue() {
        return this.plot.getRangeAxis().getLowerBound();
    }

    private double getMaxRangeValue() {
        return this.plot.getRangeAxis().getUpperBound();
    }

    private void setChartRange(int n, double d, int n2, double d2) {
        Range2D range2D;
        this.range = range2D = new Range2D(n, d, n2, d2);
        this.plot.getRangeAxis().setRange(d, d2);
        this.plot.getDomainAxis().setRange(n, n2);
        this.updateChartBuffer();
        this.repaintAll();
    }

    private void updateGridlines() {
        double d;
        this.plot.clearDomainMarkers();
        this.plot.addDomainMarker(new ValueMarker(5.0, Color.lightGray, new BasicStroke(1.0f)));
        this.plot.addDomainMarker(new ValueMarker(10.0, Color.lightGray, new BasicStroke(1.0f)));
        this.plot.addDomainMarker(new ValueMarker(15.0, Color.lightGray, new BasicStroke(1.0f)));
        this.plot.addDomainMarker(new ValueMarker(20.0, Color.lightGray, new BasicStroke(1.0f)));
        this.plot.addDomainMarker(new ValueMarker(25.0, Color.lightGray, new BasicStroke(1.0f)));
        for (d = this.defaultMaxY / 4.0; d < this.plot.getRangeAxis().getRange().getUpperBound(); d += this.defaultMaxY / 4.0) {
            this.plot.addRangeMarker(new ValueMarker(d, Color.lightGray, new BasicStroke(1.0f)));
        }
        for (d = -this.defaultMaxY / 4.0; d > this.plot.getRangeAxis().getRange().getLowerBound(); d -= this.defaultMaxY / 4.0) {
            this.plot.addRangeMarker(new ValueMarker(d, Color.lightGray, new BasicStroke(1.0f)));
        }
    }

    private void updateCursorLocation() {
        double d = this.timeSeriesModel.getPlaybackTime();
        Point2D point2D = this.toImageLocation(d, 0.0);
        this.cursorPNode.setOffset(point2D);
    }

    public void setMinimized(boolean bl) {
        if (this.minimized != bl) {
            this.minimized = bl;
            this.setMinimizedState(bl);
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.minimizeStateChanged();
            }
        }
    }

    private void setHasChild(boolean bl, PNode pNode) {
        if (bl && !this.isAncestorOf(pNode)) {
            this.addChild(pNode);
        } else if (!bl && this.isAncestorOf(pNode)) {
            this.removeChild(pNode);
        }
    }

    private void setMinimizedState(boolean bl) {
        TimeSeriesPNode timeSeriesPNode;
        int n;
        this.setHasChild(!bl, this.chartGraphic);
        this.setHasChild(!bl, this.cursorPNode);
        this.setHasChild(bl, this.maxButNode);
        this.setHasChild(!bl, this.minButNode);
        this.setHasChild(!bl, this.zoomInGraphic);
        this.setHasChild(!bl, this.zoomOutGraphic);
        if (this.slider != null) {
            this.setHasChild(!bl, this.slider);
        }
        for (n = 0; n < this.series.size(); ++n) {
            timeSeriesPNode = (TimeSeriesPNode)this.series.get(n);
            this.setHasChild(!bl, timeSeriesPNode.getReadoutGraphic());
        }
        this.updateCursor();
        for (n = 0; n < this.series.size(); ++n) {
            timeSeriesPNode = (TimeSeriesPNode)this.series.get(n);
            timeSeriesPNode.getReadoutGraphic().setVisible(!bl);
        }
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    private void showCursor() {
        this.cursorPNode.setVisible(true);
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
    }

    private void hideCursor() {
        this.cursorPNode.setVisible(false);
    }

    public void setChartSize(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RuntimeException("Illegal chart dimensions: " + n + ", " + n2);
        }
        if (this.chartWidth != n || this.chartHeight != n2) {
            this.dataAreaDirty = true;
            this.layoutDirty = true;
            this.chartWidth = n;
            this.chartHeight = n2;
            this.repaintAll();
            this.updateCursor();
            this.invalidateLayout();
        }
    }

    protected void layoutChildren() {
        if (this.layoutDirty) {
            double d;
            PNode pNode;
            TimeSeriesPNode timeSeriesPNode;
            int n;
            super.layoutChildren();
            this.dataAreaDirty = true;
            for (n = 0; n < this.series.size() / 2; ++n) {
                timeSeriesPNode = (TimeSeriesPNode)this.series.get(n);
                pNode = timeSeriesPNode.getReadoutGraphic();
                d = -2.0;
                pNode.setOffset(this.getDataArea().getX() + 5.0, this.getDataArea().getY() + 4.0 + (pNode.getFullBounds().getHeight() + d) * (double)n);
            }
            for (n = this.series.size() / 2; n < this.series.size(); ++n) {
                timeSeriesPNode = (TimeSeriesPNode)this.series.get(n);
                pNode = timeSeriesPNode.getReadoutGraphic();
                d = -2.0;
                int n2 = n - this.series.size() / 2;
                pNode.setOffset(this.getDataArea().getX() + this.getDataArea().getWidth() / 2.0 + 5.0, this.getDataArea().getY() + 4.0 + (pNode.getFullBounds().getHeight() + d) * (double)n2);
            }
            this.zoomInGraphic.setOffset(5.0 + this.getDataArea().getX(), this.getDataArea().getMaxY() - this.zoomOutGraphic.getFullBounds().getHeight() - this.zoomInGraphic.getFullBounds().getHeight() - 2.0);
            this.zoomOutGraphic.setOffset(this.zoomInGraphic.getOffset().getX(), this.zoomInGraphic.getOffset().getY() + this.zoomInGraphic.getFullBounds().getHeight());
            ++this.layoutCount;
            if (this.layoutCount > 100) {
                System.out.println("layoutCount = " + this.layoutCount);
            }
            if (this.slider != null) {
                this.slider.dataAreaChanged(this.getDataArea());
            }
            this.minButNode.setOffset(this.getDataArea().getMaxX() - this.minButNode.getFullBounds().getWidth() - 2.0, 2.0);
            this.layoutDirty = false;
        }
    }

    private void updateCursor() {
        this.updateCursorSize();
        this.updateCursorLocation();
    }

    private void updateCursorSize() {
        Rectangle2D rectangle2D = this.getDataArea();
        int n = 6;
        this.cursorPNode.setPathTo(new Rectangle2D.Double(-n / 2, -rectangle2D.getHeight() / 2.0, n, rectangle2D.getHeight()));
    }

    private void updateChartBuffer() {
        this.layoutDirty = true;
        this.updateGridlines();
        if (this.chartWidth < 2000 && this.chartHeight < 2000) {
            this.bufferedImage = this.chart.createBufferedImage(this.chartWidth, this.chartHeight);
            this.decorateBuffer();
            this.chartGraphic.setImage(this.bufferedImage);
        }
    }

    private void decorateBuffer() {
        this.drawInPlotAxis();
    }

    private void drawInPlotAxis() {
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        for (int i = 2; i < 30; i += 2) {
            Point2D point2D = this.toImageLocation(i, 0.0);
            PText pText = new PText("" + i);
            pText.setOffset(point2D.getX() - pText.getWidth() / 2.0, point2D.getY());
            pText.setFont(new PhetFont(10));
            pText.fullPaint(new PPaintContext(graphics2D));
        }
    }

    private static JFreeChart createChart(Range2D range2D, XYDataset xYDataset, String string) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("", "", "", xYDataset, PlotOrientation.VERTICAL, false, false, false);
        jFreeChart.setBackgroundPaint(EarthGraphic.earthGreen);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.white);
        xYPlot.setDomainGridlinesVisible(false);
        xYPlot.setRangeGridlinesVisible(false);
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setAutoRange(false);
        numberAxis.setRange(range2D.getMinX(), range2D.getMaxX());
        numberAxis.setTickLabelsVisible(false);
        numberAxis.setTickMarksVisible(true);
        xYPlot.setDomainAxis(numberAxis);
        NumberAxis numberAxis2 = new NumberAxis(string);
        numberAxis2.setAutoRange(false);
        numberAxis2.setRange(range2D.getMinY(), range2D.getMaxY());
        numberAxis2.setLabelFont(new Font(PhetFont.getDefaultFontName(), 0, 11));
        xYPlot.setRangeAxis(numberAxis2);
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        return jFreeChart;
    }

    private static XYDataset createDataset() {
        XYSeries xYSeries = new XYSeries(new Integer(0));
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public void addTimeSeries(TimeSeriesPNode timeSeriesPNode) {
        PNode pNode = timeSeriesPNode.getReadoutGraphic();
        this.series.add(timeSeriesPNode);
        this.addChild(pNode);
        this.invalidateLayout();
    }

    public void reset() {
        this.updateChartBuffer();
    }

    public BufferedImage getChartImage() {
        return this.bufferedImage;
    }

    public Rectangle2D getDataArea() {
        return this.getDataArea(this.plot);
    }

    private Rectangle2D getDataArea(XYPlot xYPlot) {
        if (this.savedDataArea == null || this.dataAreaDirty) {
            BufferedImage bufferedImage = new BufferedImage(2, 2, 1);
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
            this.chart.draw(bufferedImage.createGraphics(), new Rectangle2D.Double(0.0, 0.0, this.chartWidth, this.chartHeight), chartRenderingInfo);
            Rectangle2D rectangle2D = chartRenderingInfo.getPlotInfo().getDataArea();
            this.savedDataArea = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            this.dataAreaDirty = false;
        }
        return this.savedDataArea;
    }

    public LinearTransform2D toLinearFunction() {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(1.0, 1.0);
        Point2D point2D = this.toImageLocation(((Point2D)double_).getX(), ((Point2D)double_).getY());
        Point2D point2D2 = this.toImageLocation(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
        return new LinearTransform2D(double_, double_2, point2D, point2D2);
    }

    public Point2D toImageLocation(double d, double d2) {
        Rectangle2D rectangle2D = this.getDataArea(this.plot);
        if (rectangle2D == null) {
            throw new RuntimeException("Null data area");
        }
        double d3 = this.plot.getDomainAxisForDataset(0).valueToJava2D(d, rectangle2D, this.plot.getDomainAxisEdge());
        double d4 = this.plot.getRangeAxisForDataset(0).valueToJava2D(d2, rectangle2D, this.plot.getRangeAxisEdge());
        return new Point2D.Double(d3, d4);
    }

    public void repaintImage(Rectangle2D rectangle2D) {
        if (rectangle2D.intersects(this.getDataArea())) {
            this.chartGraphic.repaintFrom(new PBounds(rectangle2D), this.chartGraphic);
        }
    }

    public void repaintAll() {
        this.reset();
        for (int i = 0; i < this.series.size(); ++i) {
            TimeSeriesPNode timeSeriesPNode = (TimeSeriesPNode)this.series.get(i);
            timeSeriesPNode.repaintAll();
        }
    }

    public RampModule getRampModule() {
        return this.module;
    }

    public double getButtonHeight() {
        return this.minButNode.getHeight();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void minimizeStateChanged();
    }

    static class SliderGraphic
    extends PNode {
        private int width = 25;
        private int insetX = 10;
        private PPath thumb;
        private TimePlotSuitePNode timePlotSuitePNode;
        private Rectangle2D rect;
        private BorderPNode background;
        private BorderPNode track;

        public SliderGraphic(Rectangle2D.Double double_, TimePlotSuitePNode timePlotSuitePNode) {
            this.background = new BorderPNode(timePlotSuitePNode.pCanvas, BorderFactory.createLoweredBevelBorder(), RectangleUtils.toRectangle(double_));
            Rectangle rectangle = this.createCenter(double_);
            this.track = new BorderPNode(timePlotSuitePNode.pCanvas, BorderFactory.createRaisedBevelBorder(), rectangle);
            this.addChild(this.track);
            this.rect = double_;
            timePlotSuitePNode.getRampModule().getRampPhysicalModel().addListener(new RampPhysicalModel.Adapter(){

                public void appliedForceChanged() {
                    SliderGraphic.this.update();
                }
            });
            this.timePlotSuitePNode = timePlotSuitePNode;
            this.thumb = new PPath();
            Arrow arrow = new Arrow(new Point2D.Double(), new Point2D.Double(23.0, 0.0), 10.0, 15.0, 7.0);
            this.thumb.setPathTo(arrow.getShape());
            this.thumb.setPaint(new RampLookAndFeel().getAppliedForceColor());
            this.thumb.setStroke(new BasicStroke());
            this.thumb.setStrokePaint(Color.black);
            this.addChild(this.thumb);
            this.thumb.addInputEventListener(new CursorHandler(12));
            this.thumb.addInputEventListener(new ThumbDrag(this));
            this.setPickable(false);
            this.setChildrenPickable(true);
            this.background.setPickable(false);
            this.background.setChildrenPickable(false);
        }

        private Rectangle createCenter(Rectangle2D rectangle2D) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY(), 1.0, rectangle2D.getHeight());
            return RectangleUtils.toRectangle(double_);
        }

        private void update() {
            Point2D point2D = this.timePlotSuitePNode.toImageLocation(0.0, this.timePlotSuitePNode.getRampModule().getRampPhysicalModel().getAppliedForceScalar());
            double d = point2D.getY();
            if (d < this.rect.getY()) {
                d = this.rect.getY();
            } else if (d > this.rect.getMaxY()) {
                d = this.rect.getMaxY();
            }
            this.thumb.setOffset(this.rect.getX() + 2.0, d);
        }

        public void dataAreaChanged(Rectangle2D rectangle2D) {
            if (!rectangle2D.equals(this.rect)) {
                int n = 30;
                this.rect = new Rectangle2D.Double(this.insetX - n, rectangle2D.getY(), this.width, rectangle2D.getHeight());
                this.background.setBorderRectangle(RectangleUtils.toRectangle(this.rect));
                this.track.setBorderRectangle(this.createCenter(this.rect));
                this.update();
            }
        }

        static class ThumbDrag
        extends PBasicInputEventHandler {
            private SliderGraphic sliderGraphic;

            public ThumbDrag(SliderGraphic sliderGraphic) {
                this.sliderGraphic = sliderGraphic;
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                Point2D point2D = pInputEvent.getPositionRelativeTo(this.sliderGraphic);
                LinearTransform2D linearTransform2D = this.sliderGraphic.timePlotSuitePNode.toLinearFunction();
                AffineTransform affineTransform = linearTransform2D.getInverseTransform();
                Point2D point2D2 = affineTransform.transform(point2D, null);
                double d = -point2D2.getY();
                if (d > this.sliderGraphic.timePlotSuitePNode.getMaxRangeValue()) {
                    d = this.sliderGraphic.timePlotSuitePNode.getMaxRangeValue();
                } else if (d < this.sliderGraphic.timePlotSuitePNode.getMinRangeValue()) {
                    d = this.sliderGraphic.timePlotSuitePNode.getMinRangeValue();
                }
                this.sliderGraphic.timePlotSuitePNode.getRampModule().getRampPhysicalModel().setAppliedForce(d);
            }
        }
    }
}

