/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view.bars;

import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.theramp.common.BarGraphic2D;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.ValueAccessor;
import edu.colorado.phet.theramp.view.EarthGraphic;
import edu.colorado.phet.theramp.view.RampFontSet;
import edu.colorado.phet.theramp.view.RampLookAndFeel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class BarGraphSet
extends PNode {
    private RampPanel rampPanel;
    private RampPhysicalModel rampPhysicalModel;
    private ModelViewTransform1D transform1D;
    private double barChartHeight;
    private double barWidth;
    private double dw;
    private double sep;
    private int dx = 10;
    private int dy = -10;
    private double topY;
    private ShadowHTMLNode titleNode;
    private XAxis xAxis;
    private PPath background;
    private YAxis yAxis;
    private PSwing minButNode;
    private PNode maximizeButton;
    private ArrayList barGraphics = new ArrayList();
    private boolean minimized = false;

    public BarGraphSet(RampPanel rampPanel, RampPhysicalModel rampPhysicalModel, String string, ModelViewTransform1D modelViewTransform1D) {
        this.rampPanel = rampPanel;
        this.rampPhysicalModel = rampPhysicalModel;
        this.transform1D = modelViewTransform1D;
        this.topY = 0.0;
        this.barChartHeight = 450.0;
        this.barWidth = 13.0;
        this.dw = 7.0;
        this.sep = this.barWidth + this.dw;
        this.titleNode = new ShadowHTMLNode(string);
        this.titleNode.setColor(Color.black);
        this.titleNode.setShadowColor(Color.blue);
        this.titleNode.setFont(RampFontSet.getFontSet().getBarGraphTitleFont());
        JButton jButton = new JButton("" + string);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarGraphSet.this.setMinimized(false);
            }
        });
        jButton.setFont(RampFontSet.getFontSet().getNormalButtonFont());
        jButton.setBackground(EarthGraphic.earthGreen);
        this.maximizeButton = new PSwing(jButton);
    }

    public void setBarChartHeight(double d) {
        this.barChartHeight = d;
        this.xAxis.setBarChartHeight(d);
        this.yAxis.setBarChartHeight(d);
        for (int i = 0; i < this.barGraphics.size(); ++i) {
            BarGraphic2D barGraphic2D = (BarGraphic2D)this.barGraphics.get(i);
            barGraphic2D.setBarHeight(d);
        }
    }

    private void setHasChild(boolean bl, PNode pNode) {
        if (bl && !this.isAncestorOf(pNode)) {
            this.addChild(pNode);
        } else if (!bl && this.isAncestorOf(pNode)) {
            this.removeChild(pNode);
        }
    }

    protected void addMinimizeButton() {
        JButton jButton = null;
        try {
            jButton = new JButton(new ImageIcon(ImageLoader.loadBufferedImage("the-ramp/images/min15.jpg")));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BarGraphSet.this.setMinimized(true);
                }
            });
            jButton.setMargin(new Insets(2, 2, 2, 2));
            this.minButNode = new PSwing(jButton);
            this.minButNode.setOffset(5.0, this.topY + 10.0);
            this.addChild(this.minButNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.titleNode.setOffset(this.minButNode.getFullBounds().getMaxX() + 2.0, this.topY + 10.0);
        this.maximizeButton.setOffset(this.minButNode.getOffset());
    }

    public void setMinimized(boolean bl) {
        this.minimized = bl;
        this.setHasChild(!bl, this.background);
        this.setHasChild(!bl, this.xAxis);
        this.setHasChild(!bl, this.yAxis);
        for (int i = 0; i < this.barGraphics.size(); ++i) {
            BarGraphic2D barGraphic2D = (BarGraphic2D)this.barGraphics.get(i);
            this.setHasChild(!bl, barGraphic2D);
        }
        this.setHasChild(!bl, this.minButNode);
        this.setHasChild(!bl, this.titleNode);
        this.setHasChild(bl, this.maximizeButton);
        this.rampPanel.relayoutPiccolo();
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    protected RampLookAndFeel getLookAndFeel() {
        return this.rampPanel.getLookAndFeel();
    }

    public double getMaxDisplayableEnergy() {
        return Math.abs(this.transform1D.viewToModelDifferential((int)(this.barChartHeight - this.topY)));
    }

    protected void addClockListener(ClockListener clockListener) {
        this.rampPanel.getRampModule().getClock().addClockListener(clockListener);
    }

    protected void finishInit(ValueAccessor[] valueAccessorArray) {
        double d = (double)valueAccessorArray.length * (this.sep + this.dw) - this.sep;
        this.background = new PPath(new Rectangle2D.Double(0.0, this.topY, 2.0 + d, 1000.0));
        this.background.setPaint(null);
        this.background.setStroke(new BasicStroke());
        this.background.setStrokePaint(null);
        this.addChild(this.background);
        this.xAxis = new XAxis();
        this.addChild(this.xAxis);
        this.yAxis = new YAxis();
        this.addChild(this.yAxis);
        for (int i = 0; i < valueAccessorArray.length; ++i) {
            final ValueAccessor valueAccessor = valueAccessorArray[i];
            final BarGraphic2D barGraphic2D = new BarGraphic2D(valueAccessor.getName(), this.transform1D, valueAccessor.getValue(this.rampPhysicalModel), (int)((double)i * this.sep + this.dw), (int)this.barWidth, (int)this.barChartHeight, this.dx, this.dy, valueAccessor.getColor());
            this.addClockListener(new ClockAdapter(){

                public void clockTicked(ClockEvent clockEvent) {
                    barGraphic2D.setValue(valueAccessor.getValue(BarGraphSet.this.rampPhysicalModel));
                }
            });
            this.addBarGraphic(barGraphic2D);
        }
        this.addChild(this.titleNode);
        this.addMinimizeButton();
    }

    private void addBarGraphic(BarGraphic2D barGraphic2D) {
        this.addChild(barGraphic2D);
        this.barGraphics.add(barGraphic2D);
    }

    private class XAxis
    extends PNode {
        private PPath path;

        public XAxis() {
            int n = BarGraphSet.this.transform1D.modelToView(0.0);
            this.path = new PPath(this.createLinePath());
            this.addChild(this.path);
            this.path.setStrokePaint(new Color(255, 150, 150));
            this.path.setStroke(new BasicStroke(3.0f));
        }

        private Line2D.Double createLinePath() {
            return new Line2D.Double(0.0, BarGraphSet.this.barChartHeight, BarGraphSet.this.background.getFullBounds().getWidth(), BarGraphSet.this.barChartHeight);
        }

        public void setBarChartHeight(double d) {
            this.path.setPathTo(this.createLinePath());
        }
    }

    private class YAxis
    extends PNode {
        private PPath path;

        public YAxis() {
            GeneralPath generalPath = this.createShape();
            this.path = new PPath(generalPath);
            this.path.setPaint(Color.black);
            this.addChild(this.path);
        }

        private GeneralPath createShape() {
            Point2D.Double double_ = new Point2D.Double(0.0, BarGraphSet.this.barChartHeight);
            Point2D.Double double_2 = new Point2D.Double(0.0, BarGraphSet.this.topY + 25.0);
            try {
                Arrow arrow = new Arrow(double_, double_2, 8.0, 8.0, 3.0);
                GeneralPath generalPath = arrow.getShape();
                return generalPath;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                return new GeneralPath();
            }
        }

        public void setBarChartHeight(double d) {
            this.path.setPathTo(this.createShape());
        }
    }
}

