/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import java.text.DecimalFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InitialConditionPanel
extends VerticalLayoutPanel {
    public InitialConditionPanel(final RampModule rampModule) {
        double d = 3000.0;
        final ModelSlider modelSlider = new ModelSlider(TheRampStrings.getString("forces.applied-force"), TheRampStrings.getString("units.newtons"), -d, d, 0.0, new DecimalFormat("0.00"));
        modelSlider.setModelTicks(new double[]{-d, 0.0, d});
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rampModule.setAppliedForce(modelSlider.getValue());
            }
        });
        rampModule.getRampPhysicalModel().addListener(new RampPhysicalModel.Adapter(){

            public void appliedForceChanged() {
                modelSlider.setValue(rampModule.getRampPhysicalModel().getAppliedForceScalar());
            }
        });
        this.addFullWidth(modelSlider);
        final ModelSlider modelSlider2 = new ModelSlider(TheRampStrings.getString("property.ramp-angle"), TheRampStrings.getString("units.degrees"), 0.0, 90.0, rampModule.getRampAngle() * 180.0 / Math.PI);
        modelSlider2.setModelTicks(new double[]{0.0, 45.0, 90.0});
        modelSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = modelSlider2.getValue() * Math.PI * 2.0 / 360.0;
                rampModule.setRampAngle(d);
            }
        });
        rampModule.getRampPhysicalModel().getRamp().addObserver(new SimpleObserver(){

            public void update() {
                modelSlider2.setValue(rampModule.getRampAngle() * 180.0 / Math.PI);
            }
        });
        this.addFullWidth(modelSlider2);
        final ModelSlider modelSlider3 = new ModelSlider(TheRampStrings.getString("property.position"), TheRampStrings.getString("units.abbr.meters"), rampModule.getGlobalMinPosition(), rampModule.getGlobalMaxPosition(), rampModule.getGlobalBlockPosition());
        modelSlider3.setModelTicks(new double[]{rampModule.getGlobalMinPosition(), (rampModule.getGlobalMaxPosition() + rampModule.getGlobalMinPosition()) / 2.0, rampModule.getGlobalMaxPosition()});
        modelSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = modelSlider3.getValue();
                rampModule.setGlobalBlockPosition(d);
            }
        });
        rampModule.getBlock().addListener(new Block.Adapter(){

            public void surfaceChanged() {
                modelSlider3.setValue(rampModule.getGlobalBlockPosition());
            }

            public void positionChanged() {
                modelSlider3.setValue(rampModule.getGlobalBlockPosition());
            }
        });
        this.addFullWidth(modelSlider3);
        final ModelSlider modelSlider4 = new ModelSlider(TheRampStrings.getString("controls.velocity"), TheRampStrings.getString("units.meters-per-second"), -20.0, 20.0, rampModule.getBlock().getVelocity());
        modelSlider4.setModelTicks(new double[]{-20.0, 0.0, 20.0});
        modelSlider4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rampModule.getBlock().setVelocity(modelSlider4.getValue());
            }
        });
        rampModule.getBlock().addListener(new Block.Adapter(){

            public void velocityChanged() {
                modelSlider4.setValue(rampModule.getBlock().getVelocity());
            }
        });
        this.addFullWidth(modelSlider4);
    }
}

