/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.view.RampLookAndFeel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.colorado.phet.theramp.view.ThresholdedPDragAdapter;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class FreeBodyDiagram
extends PNode {
    private RampModule module;
    private PPath background;
    private AxesGraphic axes;
    private Rectangle rect;
    private ForceArrow mg;
    private ForceArrow normal;
    private ForceArrow appliedForce;
    private ForceArrow wallForce;
    private ForceArrow frictionForce;
    private ForceArrow netForce;
    private double scale = 0.05;
    private RampLookAndFeel laf;
    private boolean userClicked = false;
    private RampPhysicalModel model;
    private RampPanel component;
    private JComponent owner;

    public FreeBodyDiagram(RampPanel rampPanel, final RampModule rampModule, JComponent jComponent) {
        this.component = rampPanel;
        this.owner = jComponent;
        this.model = rampModule.getRampPhysicalModel();
        this.module = rampModule;
        this.rect = new Rectangle(0, 0, 200, 200);
        this.laf = new RampLookAndFeel();
        this.background = new PPath(this.rect);
        this.background.setPaint(Color.white);
        this.background.setStroke(new BasicStroke(1.0f));
        this.background.setStrokePaint(Color.black);
        this.addChild(this.background);
        this.axes = new AxesGraphic();
        this.addChild(this.axes);
        this.mg = new ForceArrow(this, this.laf.getWeightColor(), TheRampStrings.getString("force.subscript.gravity"), new MutableVector2D(0.0, 80.0));
        this.addForceArrow(this.mg);
        this.normal = new ForceArrow(this, this.laf.getNormalColor(), TheRampStrings.getString("force.subscript.normal"), new MutableVector2D(0.0, 80.0));
        this.addForceArrow(this.normal);
        this.appliedForce = new ForceArrow(this, this.laf.getAppliedForceColor(), TheRampStrings.getString("force.subscript.applied"), new MutableVector2D());
        this.addForceArrow(this.appliedForce);
        this.frictionForce = new ForceArrow(this, this.laf.getFrictionForceColor(), TheRampStrings.getString("force.subscript.friction"), new MutableVector2D());
        this.addForceArrow(this.frictionForce);
        this.netForce = new ForceArrow(this, this.laf.getNetForceColor(), TheRampStrings.getString("force.subscript.net"), new MutableVector2D());
        this.addForceArrow(this.netForce);
        this.netForce.setVerticalOffset(-30.0);
        this.wallForce = new ForceArrow(this, this.laf.getWallForceColor(), TheRampStrings.getString("force.subscript.wall"), new MutableVector2D());
        this.addForceArrow(this.wallForce);
        this.wallForce.setVerticalOffset(-30.0);
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                rampModule.record();
                FreeBodyDiagram.this.setForce(pInputEvent.getPositionRelativeTo(FreeBodyDiagram.this));
                FreeBodyDiagram.this.userClicked = true;
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                FreeBodyDiagram.this.setForce(pInputEvent.getPositionRelativeTo(FreeBodyDiagram.this));
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                FreeBodyDiagram.this.model.setAppliedForce(0.0);
            }
        };
        ThresholdedPDragAdapter thresholdedPDragAdapter = new ThresholdedPDragAdapter(pBasicInputEventHandler, 10, 0, 1000L);
        this.addInputEventListener(thresholdedPDragAdapter);
        this.addInputEventListener(new CursorHandler(12));
        this.updateAll();
        rampModule.getModel().addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                FreeBodyDiagram.this.updateAll();
            }
        });
        PText pText = new PText(TheRampStrings.getString("display.free-body-diagram"));
        this.addChild(pText);
    }

    private void setForce(Point2D point2D) {
        double d = point2D.getX();
        double d2 = d - this.getCenter().getX();
        double d3 = d2 / this.scale;
        this.model.setAppliedForce(d3);
    }

    private void updateXForces() {
        MutableVector2D mutableVector2D = new MutableVector2D(this.model.getAppliedForce().times(this.scale));
        this.appliedForce.setVector(mutableVector2D);
        MutableVector2D mutableVector2D2 = new MutableVector2D(this.model.getFrictionForce().times(this.scale));
        this.frictionForce.setVector(mutableVector2D2);
        Vector2D vector2D = new Vector2D(this.model.getTotalForce().times(this.scale));
        this.netForce.setVector(vector2D);
        MutableVector2D mutableVector2D3 = new MutableVector2D(this.model.getWallForce().times(this.scale));
        this.wallForce.setVector(mutableVector2D3);
    }

    private void updateMG() {
        RampPhysicalModel.ForceVector forceVector = this.model.getGravityForce();
        this.mg.setVector(forceVector.times(this.scale));
        this.normal.setVector(this.model.getNormalForce().times(this.scale));
    }

    public void addForceArrow(ForceArrow forceArrow) {
        this.addChild(forceArrow);
    }

    private Point2D getCenter() {
        return RectangleUtils.getCenter(this.rect);
    }

    public void updateAll() {
        if (this.owner.isVisible()) {
            this.updateXForces();
            this.updateMG();
            this.axes.update();
        }
    }

    private RampPanel getRampPanel() {
        return this.component;
    }

    public class AxesGraphic
    extends PNode {
        private PPath xAxis;
        private PPath yAxis;
        private Line2D.Double yLine = null;
        private Line2D.Double xLine = null;

        public AxesGraphic() {
            BasicStroke basicStroke = new BasicStroke(1.0f);
            Color color = Color.black;
            this.xAxis = new PPath();
            this.xAxis.setStroke(basicStroke);
            this.xAxis.setStrokePaint(color);
            this.yAxis = new PPath();
            this.yAxis.setStroke(basicStroke);
            this.yAxis.setStrokePaint(color);
            this.addChild(this.xAxis);
            this.addChild(this.yAxis);
            this.update();
        }

        public void update() {
            Line2D.Double double_ = new Line2D.Double(((FreeBodyDiagram)FreeBodyDiagram.this).rect.x, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.height / 2, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.x + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.width, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.height / 2);
            Line2D.Double double_2 = new Line2D.Double(((FreeBodyDiagram)FreeBodyDiagram.this).rect.x + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.width / 2, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.x + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.width / 2, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.height);
            if (this.xLine == null || !double_.equals(this.xLine)) {
                this.xLine = double_;
                this.xAxis.setPathTo(double_);
            }
            if (this.yLine == null || !double_2.equals(this.yLine)) {
                this.yLine = double_2;
                this.yAxis.setPathTo(double_2);
            }
        }
    }

    public static class ForceArrow
    extends PNode {
        private PPath shapeGraphic;
        private HTMLNode textGraphic;
        private FreeBodyDiagram fbd;
        private String name;
        private Arrow lastArrow;
        private double verticalOffset = 0.0;

        public ForceArrow(FreeBodyDiagram freeBodyDiagram, Color color, String string, MutableVector2D mutableVector2D) {
            this.fbd = freeBodyDiagram;
            this.name = string;
            this.shapeGraphic = new PPath();
            this.shapeGraphic.setStroke(new BasicStroke(1.5f, 1, 1));
            this.shapeGraphic.setPaint(color);
            this.shapeGraphic.setStrokePaint(Color.black);
            this.addChild(this.shapeGraphic);
            Font font = new Font(PhetFont.getDefaultFontName(), 1, 16);
            this.textGraphic = new HTMLNode(string, color, font);
            this.addChild(this.textGraphic);
            this.setVector(mutableVector2D);
            this.setPickable(false);
            this.setChildrenPickable(false);
        }

        public void setVerticalOffset(double d) {
            this.verticalOffset = d;
        }

        public void setVector(AbstractVector2D abstractVector2D) {
            Point2D point2D = this.fbd.getCenter();
            SurfaceGraphic surfaceGraphic = this.fbd.getRampPanel().getRampWorld().getBlockGraphic().getCurrentSurfaceGraphic();
            double d = surfaceGraphic.getViewAngle();
            point2D = MutableVector2D.createPolar(this.verticalOffset, d).getPerpendicularVector().getPerpendicularVector().getPerpendicularVector().getDestination(point2D);
            Arrow arrow = new Arrow(point2D, abstractVector2D.getDestination(point2D), 20.0, 20.0, 8.0, 0.5, true);
            GeneralPath generalPath = arrow.getShape();
            if (this.lastArrow == null || !this.lastArrow.equals(arrow)) {
                this.shapeGraphic.setPathTo(generalPath);
            }
            this.lastArrow = arrow;
            Rectangle rectangle = generalPath.getBounds();
            Point point = RectangleUtils.getCenter(rectangle);
            if (abstractVector2D.getX() > 0.0) {
                this.textGraphic.setOffset(rectangle.x + rectangle.width + 5, (double)point.y - this.textGraphic.getHeight() / 2.0);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getX() < 0.0) {
                this.textGraphic.setOffset((double)rectangle.x - this.textGraphic.getWidth() - 5.0, (double)point.y - this.textGraphic.getHeight() / 2.0);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getY() > 0.0) {
                this.textGraphic.setOffset((double)point.x - this.textGraphic.getWidth() / 2.0, rectangle.y + rectangle.height);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getY() < 0.0) {
                this.textGraphic.setOffset((double)point.x - this.textGraphic.getWidth() / 2.0, (double)rectangle.y - this.textGraphic.getHeight());
                this.textGraphic.setVisible(true);
            } else {
                this.textGraphic.setVisible(false);
            }
            if (abstractVector2D.magnitude() <= 0.05) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
        }
    }
}

